/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.featurepath;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsSegmentResolver;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeSegmentTester;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="FeatureSegmentStructuralChangeTester")
public class FeatureSegmentStructuralChangeTester
implements StructuralChangeSegmentTester {
    private EMFFormsSegmentResolver segmentResolver;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsSegmentResolver(EMFFormsSegmentResolver segmentResolver) {
        this.segmentResolver = segmentResolver;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public boolean isStructureChanged(VDomainModelReferenceSegment segment, EObject domainObject, ModelChangeNotification notification) {
        EStructuralFeature.Setting setting;
        Assert.create((Object)segment).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)segment).ofClass(VFeatureDomainModelReferenceSegment.class);
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        try {
            setting = this.segmentResolver.resolveSegment(segment, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        if (EReference.class.isInstance(setting.getEStructuralFeature())) {
            EReference eReference = (EReference)setting.getEStructuralFeature();
            return eReference.equals(notification.getStructuralFeature()) && notification.getNotifier() == setting.getEObject();
        }
        return false;
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference segment was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (VFeatureDomainModelReferenceSegment.class.isInstance(segment)) {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }
}

