/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.compoundcontrol.swt;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.common.util.RendererUtil;
import org.eclipse.emf.ecp.view.spi.compoundcontrol.model.VCompoundControl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRendererUtil;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTRendererUtil;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.labelwidth.model.VTLabelWidthStyleProperty;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryStyleProperty;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CompoundControlSWTRenderer
extends AbstractSWTRenderer<VCompoundControl> {
    private static final String SEPARATOR = " / ";
    private SWTGridDescription rendererGridDescription;
    private final EMFFormsLabelProvider labelProvider;
    private EMFDataBindingContext dataBindingContext;
    private final EMFFormsRendererFactory rendererFactory;
    private LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> elementRendererMap;
    private final VTViewTemplateProvider viewTemplateProvider;
    private boolean firstControlValidationIconUsed;
    private final EMFFormsDatabindingEMF databindingService;

    @Inject
    public CompoundControlSWTRenderer(VCompoundControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsLabelProvider labelProvider, EMFFormsRendererFactory rendererFactory, VTViewTemplateProvider viewTemplateProvider, EMFFormsDatabindingEMF databindingService) {
        super((VElement)vElement, viewContext, reportService);
        this.labelProvider = labelProvider;
        this.rendererFactory = rendererFactory;
        this.viewTemplateProvider = viewTemplateProvider;
        this.databindingService = databindingService;
    }

    protected EMFFormsLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected EMFFormsRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    protected EMFFormsDatabindingEMF getDatabindingService() {
        return this.databindingService;
    }

    protected DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> getElementRendererMap() {
        this.initChildRendererMap();
        return this.elementRendererMap;
    }

    private void setElementRendererMap(LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>> elementRendererMap) {
        this.elementRendererMap = elementRendererMap;
    }

    protected VTViewTemplateProvider getViewTemplateProvider() {
        return this.viewTemplateProvider;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            int columns = SimpleControlSWTRendererUtil.showLabel((VControl)((VControl)this.getVElement()), (ReportService)this.getReportService(), (String)((Object)((Object)this)).getClass().getName()) ? 3 : 2;
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createEmptyGridDescription();
            this.rendererGridDescription.setRows(1);
            this.rendererGridDescription.setColumns(columns);
            ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
            if (columns == 3) {
                SWTGridCell labelCell = SimpleControlSWTRendererUtil.createLabelCell((int)grid.size(), (AbstractSWTRenderer)this, this.getLabelWidth());
                grid.add(labelCell);
            }
            SWTGridCell validationCell = SimpleControlSWTRendererUtil.createValidationCell((int)grid.size(), (AbstractSWTRenderer)this);
            grid.add(validationCell);
            SWTGridCell controlCel = SimpleControlSWTRendererUtil.createControlCell((int)grid.size(), (AbstractSWTRenderer)this);
            grid.add(controlCel);
            this.rendererGridDescription.setGrid(grid);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = cell.getColumn();
        if (((VCompoundControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                return this.createControls(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", cell.toString(), ((Object)((Object)this)).toString()));
    }

    protected Control createLabel(Composite parent) {
        Label label = new Label(parent, this.getLabelStyleBits());
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)label, (VElement)this.getVElement(), (String)"control_label", (ViewModelContext)this.getViewModelContext());
        label.setBackground(parent.getBackground());
        ISWTObservableValue textObservable = WidgetProperties.text().observe((Widget)label);
        Map<IObservableValue, Map.Entry<VControl, EStructuralFeature>> displayNameObservables = this.getLabelDisplayNameObservables();
        for (IObservableValue displayNameObservable : displayNameObservables.keySet()) {
            this.getDataBindingContext().bindValue((IObservableValue)textObservable, displayNameObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new CompoundControlDisplayNameUpdateValueStrategy(displayNameObservables));
        }
        ISWTObservableValue tooltipObservable = WidgetProperties.tooltipText().observe((Widget)label);
        final List<IObservableValue> labelDescriptionObservables = this.getLabelDescriptionObservables();
        for (IObservableValue descriptionObservable : labelDescriptionObservables) {
            this.getDataBindingContext().bindValue((IObservableValue)tooltipObservable, descriptionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new EMFUpdateValueStrategy(){

                public Object convert(Object value) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (IObservableValue obs : labelDescriptionObservables) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\n");
                        }
                        stringBuilder.append(obs.getValue());
                    }
                    return stringBuilder.toString();
                }
            });
        }
        return label;
    }

    private Map<IObservableValue, Map.Entry<VControl, EStructuralFeature>> getLabelDisplayNameObservables() {
        LinkedHashMap<IObservableValue, Map.Entry<VControl, EStructuralFeature>> displayNames = new LinkedHashMap<IObservableValue, Map.Entry<VControl, EStructuralFeature>>();
        for (VControl control : ((VCompoundControl)this.getVElement()).getControls()) {
            try {
                IObservableValue displayName = this.labelProvider.getDisplayName(control.getDomainModelReference(), this.getViewModelContext().getDomainModel());
                EStructuralFeature feature = this.getDatabindingService().getValueProperty(control.getDomainModelReference(), this.getViewModelContext().getDomainModel()).getStructuralFeature();
                displayNames.put(displayName, new AbstractMap.SimpleEntry<VControl, EStructuralFeature>(control, feature));
            }
            catch (NoLabelFoundException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, 2));
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, 2));
            }
        }
        return displayNames;
    }

    private List<IObservableValue> getLabelDescriptionObservables() {
        ArrayList<IObservableValue> labelDescriptionObservables = new ArrayList<IObservableValue>();
        for (VControl control : ((VCompoundControl)this.getVElement()).getControls()) {
            try {
                labelDescriptionObservables.add(this.labelProvider.getDescription(control.getDomainModelReference(), this.getViewModelContext().getDomainModel()));
            }
            catch (NoLabelFoundException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, 2));
            }
        }
        return labelDescriptionObservables;
    }

    protected int getLabelStyleBits() {
        return AbstractControlSWTRendererUtil.getLabelStyleBits((VTViewTemplateProvider)this.getViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext());
    }

    protected Optional<Integer> getLabelWidth() {
        VTLabelWidthStyleProperty styleProperty = (VTLabelWidthStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTLabelWidthStyleProperty.class);
        if (styleProperty == null || !styleProperty.isSetWidth()) {
            return Optional.empty();
        }
        return Optional.of((Object)styleProperty.getWidth());
    }

    protected Control createValidationIcon(Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (((VCompoundControl)this.getVElement()).getControls().isEmpty()) {
            return this.createDummyValidationIcon(parent);
        }
        AbstractSWTRenderer<VElement> renderer = this.getElementRendererMap().get(((VCompoundControl)this.getVElement()).getControls().get(0));
        if (renderer == null) {
            return this.createDummyValidationIcon(parent);
        }
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        if (gridDescription.getColumns() < 2) {
            return this.createDummyValidationIcon(parent);
        }
        this.setFirstControlValidationIconUsed(true);
        SWTGridCell validationCell = (SWTGridCell)gridDescription.getGrid().get(0);
        return ((AbstractSWTRenderer)validationCell.getRenderer()).render(validationCell, parent);
    }

    protected void setFirstControlValidationIconUsed(boolean used) {
        this.firstControlValidationIconUsed = used;
    }

    protected Control createDummyValidationIcon(Composite parent) {
        Label validationLabel = new Label(parent, 0);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)validationLabel, (VElement)this.getVElement(), (String)"control_validation", (ViewModelContext)this.getViewModelContext());
        validationLabel.setBackground(parent.getBackground());
        return validationLabel;
    }

    protected Control createControls(Composite parent) {
        return this.createControls(parent, this.firstControlValidationIconUsed ? 1 : 0);
    }

    protected Control createControls(Composite parent, int cellsToSkip) {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        columnComposite.setLayout(this.getColumnLayout(this.getElementRendererMap().size(), false));
        for (VContainedElement child : this.getElementRendererMap().keySet()) {
            AbstractSWTRenderer<VElement> renderer = this.getElementRendererMap().get(child);
            Composite column = new Composite(columnComposite, 0);
            column.setBackground(parent.getBackground());
            column.setLayoutData(this.getSpanningLayoutData(child, 1, 1));
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            int columns = gridDescription.getColumns() - cellsToSkip;
            column.setLayout(this.getColumnLayout(columns < 1 ? 1 : columns, false));
            try {
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    if (cellsToSkip > 0) {
                        --cellsToSkip;
                        continue;
                    }
                    Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, column);
                    if (control == null) continue;
                    control.setLayoutData(this.getLayoutData(childGridCell, gridDescription, gridDescription, gridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), this.getViewModelContext().getDomainModel(), control));
                }
                for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                    ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(column);
                }
            }
            catch (NoPropertyDescriptorFoundExeption e) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            }
            catch (NoRendererFoundException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            }
        }
        return columnComposite;
    }

    protected void initChildRendererMap() {
        if (this.elementRendererMap != null) {
            return;
        }
        this.setElementRendererMap(new LinkedHashMap<VContainedElement, AbstractSWTRenderer<VElement>>());
        for (VControl child : ((VCompoundControl)this.getVElement()).getControls()) {
            AbstractSWTRenderer renderer;
            child.setLabelAlignment(LabelAlignment.NONE);
            try {
                renderer = this.getRendererFactory().getRendererInstance((VElement)child, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, String.format("No Renderer for %s found.", child.eClass().getName())));
                continue;
            }
            this.getElementRendererMap().put((VContainedElement)child, (AbstractSWTRenderer<VElement>)renderer);
        }
    }

    protected Layout getColumnLayout(int numColumns, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numColumns, (boolean)equalWidth);
    }

    protected Object getSpanningLayoutData(VContainedElement child, int spanX, int spanY) {
        return LayoutProviderHelper.getSpanningLayoutData((int)spanX, (int)spanY);
    }

    protected Object getLayoutData(SWTGridCell gridCell, SWTGridDescription controlGridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, EObject domainModel, Control control) {
        return LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)controlGridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (EObject)domainModel, (Control)control);
    }

    protected void dispose() {
        if (this.getDataBindingContext() != null) {
            this.getDataBindingContext().dispose();
        }
        super.dispose();
    }

    private final class CompoundControlDisplayNameUpdateValueStrategy
    extends EMFUpdateValueStrategy {
        private final Map<IObservableValue, Map.Entry<VControl, EStructuralFeature>> displayNameObservables;

        private CompoundControlDisplayNameUpdateValueStrategy(Map<IObservableValue, Map.Entry<VControl, EStructuralFeature>> displayNameObservables) {
            this.displayNameObservables = displayNameObservables;
        }

        public Object convert(Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<IObservableValue, Map.Entry<VControl, EStructuralFeature>> obs : this.displayNameObservables.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(CompoundControlSWTRenderer.SEPARATOR);
                }
                stringBuilder.append(this.getDisplayName(obs.getKey(), obs.getValue().getKey(), obs.getValue().getValue()));
            }
            return stringBuilder.toString();
        }

        private Object getDisplayName(IObservableValue obs, VControl control, EStructuralFeature structuralFeature) {
            Object value = obs.getValue();
            String extra = "";
            VTMandatoryStyleProperty mandatoryStyle = AbstractControlSWTRendererUtil.getMandatoryStyle((VTViewTemplateProvider)CompoundControlSWTRenderer.this.getViewTemplateProvider(), (VControl)control, (ViewModelContext)CompoundControlSWTRenderer.this.getViewModelContext());
            if (mandatoryStyle.isHighliteMandatoryFields() && structuralFeature.getLowerBound() > 0) {
                extra = mandatoryStyle.getMandatoryMarker();
            }
            return value + extra;
        }
    }
}

