/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="removeSuperfluousSuperType", label="Remove Superfluous Super Type", description="In the metamodel, a super type is removed from a class that is already inherited from another super class. In the model, nothing is changed, as this super type is superfluous.", breaking=false)
public class RemoveSuperfluousSuperType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class from which the super type is removed")
    public EClass eClass;
    @EdaptParameter(description="The super type to be removed")
    public EClass superType;

    @EdaptConstraint(restricts="superType", description="The super type to be removed actually has to be a super type")
    public boolean checkSuperType(EClass superType) {
        return this.eClass.getESuperTypes().contains((Object)superType);
    }

    @EdaptConstraint(restricts="superType", description="The super type to be removed must be subsumed by one of the other super types")
    public boolean checkSuperTypeSubsumed(EClass superType) {
        for (EClass s : this.eClass.getESuperTypes()) {
            if (!s.getEAllSuperTypes().contains((Object)superType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(Metamodel metamodel) {
        for (EClass superType : this.eClass.getESuperTypes()) {
            if (!this.checkSuperTypeSubsumed(superType)) continue;
            this.superType = superType;
            break;
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        this.eClass.getESuperTypes().remove((Object)this.superType);
    }
}

