/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.edapt;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.edapt.PackageDependencyIterator;

public class PackageDependencyGraph {
    private final Map<String, PackageTreeNode> nsURIToNodeMap;
    private final Set<PackageTreeNode> roots = new LinkedHashSet<PackageTreeNode>();

    public PackageDependencyGraph() {
        this.nsURIToNodeMap = new LinkedHashMap<String, PackageTreeNode>();
    }

    Map<String, PackageTreeNode> getNsURIToNodeMap() {
        return this.nsURIToNodeMap;
    }

    public void addPackage(String nsURI) {
        if (this.nsURIToNodeMap.containsKey(nsURI)) {
            return;
        }
        PackageTreeNode node = this.createNode(nsURI);
        this.resolveNode(node);
    }

    private void resolveNode(PackageTreeNode node) {
        LinkedHashSet<String> nsURIs = new LinkedHashSet<String>();
        EPackage rootPackage = EPackage.Registry.INSTANCE.getEPackage(node.getNSURI());
        TreeIterator iterator = rootPackage.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (EClass.class.isInstance(next)) {
                EClass eClass = (EClass)next;
                for (EClass superType : eClass.getESuperTypes()) {
                    nsURIs.add(superType.getEPackage().getNsURI());
                }
                continue;
            }
            if (!EStructuralFeature.class.isInstance(next)) continue;
            EStructuralFeature feature = (EStructuralFeature)next;
            EClassifier eType = feature.getEType();
            nsURIs.add(eType.getEPackage().getNsURI());
        }
        nsURIs.remove(node.getNSURI());
        if (nsURIs.isEmpty()) {
            this.roots.add(node);
        }
        for (String nsURI : nsURIs) {
            PackageTreeNode parent;
            if (this.nsURIToNodeMap.containsKey(nsURI)) {
                parent = this.nsURIToNodeMap.get(nsURI);
                node.addParent(parent);
                parent.addChild(node);
                continue;
            }
            parent = this.createNode(nsURI);
            this.resolveNode(parent);
            parent.addChild(node);
            node.addParent(parent);
        }
    }

    private PackageTreeNode createNode(String nsURI) {
        PackageTreeNode node = new PackageTreeNode(nsURI);
        this.nsURIToNodeMap.put(nsURI, node);
        return node;
    }

    public Iterator<Set<String>> getIerator() {
        return new PackageDependencyIterator(this.roots, this.nsURIToNodeMap.values());
    }

    static class PackageTreeNode {
        private final String nsURI;
        private final Set<PackageTreeNode> parents;
        private final Set<PackageTreeNode> children;

        public PackageTreeNode(String nsURI) {
            this.nsURI = nsURI;
            this.parents = new LinkedHashSet<PackageTreeNode>();
            this.children = new LinkedHashSet<PackageTreeNode>();
        }

        public String getNSURI() {
            return this.nsURI;
        }

        public void addParent(PackageTreeNode node) {
            this.parents.add(node);
        }

        public void addChild(PackageTreeNode node) {
            this.children.add(node);
        }

        public Set<PackageTreeNode> getParents() {
            return this.parents;
        }

        public Set<PackageTreeNode> getChildren() {
            return this.children;
        }
    }
}

