/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.controls;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.editor.controls.ExpectedValueControlRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LeafConditionControlRenderer
extends ExpectedValueControlRenderer {
    @Override
    protected void onSelectButton(Label control) {
        EStructuralFeature.Setting setting = this.getSetting((VControl)this.getVElement());
        LeafCondition condition = (LeafCondition)setting.getEObject();
        if (condition.getDomainModelReference() == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No Feature Path Domain Model Reference found", (String)"A Feature Path Domain Model Reference needs to be added to the condition first. ");
            return;
        }
        EStructuralFeature structuralFeature = ((VFeaturePathDomainModelReference)condition.getDomainModelReference()).getDomainModelEFeature();
        if (structuralFeature == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No value selected", (String)"Please set a value to the Domain Model Reference first. ");
            return;
        }
        if (EReference.class.isInstance(structuralFeature)) {
            return;
        }
        Object object = this.getSelectedObject((EAttribute)structuralFeature);
        if (object != null) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)condition);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)condition, (Object)RulePackage.eINSTANCE.getLeafCondition_ExpectedValue(), (Object)object));
            control.setText(object.toString());
        }
    }
}

