/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.table.migrate;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.view.internal.provider.Migrator;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VReadOnlyColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableFactory;

public class TableMigrator
implements Migrator {
    public void migrate(EObject eObject, FeatureMap anyAttribute, FeatureMap mixed) {
        if (!VTableControl.class.isInstance(eObject)) {
            return;
        }
        int i = 0;
        while (i < mixed.size()) {
            EStructuralFeature feature = mixed.getEStructuralFeature(i);
            AnyType object = (AnyType)mixed.getValue(i);
            if ("columns".equals(feature.getName())) {
                TableMigrator.migrateColumns((VTableControl)VTableControl.class.cast(eObject), object.getAnyAttribute(), object.getMixed());
            }
            ++i;
        }
    }

    private static void migrateColumns(VTableControl cast, FeatureMap anyAttribute, FeatureMap mixed) {
        boolean readOnly = false;
        int i = 0;
        while (i < anyAttribute.size()) {
            if ("readOnly".equals(anyAttribute.getEStructuralFeature(i).getName())) {
                readOnly = Boolean.parseBoolean((String)anyAttribute.getValue(i));
            }
            ++i;
        }
        i = 0;
        while (i < mixed.size()) {
            if ("attribute".equals(mixed.getEStructuralFeature(i).getName())) {
                AnyType object = (AnyType)mixed.getValue(i);
                URI uri = EcoreUtil.getURI((EObject)object);
                EObject eObject = cast.eResource().getResourceSet().getEObject(uri, true);
                VFeaturePathDomainModelReference dmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                dmr.setDomainModelEFeature((EStructuralFeature)eObject);
                VTableDomainModelReference tdmr = TableMigrator.getTableDomainModelReference(cast);
                if (tdmr != null) {
                    tdmr.getColumnDomainModelReferences().add((Object)dmr);
                    if (readOnly) {
                        VReadOnlyColumnConfiguration readOnlyColumnConfiguration = TableMigrator.getReadOnlyColumnConfiguration(cast);
                        readOnlyColumnConfiguration.getColumnDomainReferences().add((Object)dmr);
                    }
                }
            }
            ++i;
        }
    }

    private static VTableDomainModelReference getTableDomainModelReference(VTableControl tableControl) {
        VDomainModelReference dmr = tableControl.getDomainModelReference();
        if (VTableDomainModelReference.class.isInstance(dmr)) {
            return (VTableDomainModelReference)dmr;
        }
        for (EObject eObject : dmr.eContents()) {
            if (!VTableDomainModelReference.class.isInstance(eObject)) continue;
            return (VTableDomainModelReference)eObject;
        }
        return null;
    }

    private static VReadOnlyColumnConfiguration getReadOnlyColumnConfiguration(VTableControl cast) {
        for (VTableColumnConfiguration cc : cast.getColumnConfigurations()) {
            if (!VReadOnlyColumnConfiguration.class.isInstance(cc)) continue;
            return (VReadOnlyColumnConfiguration)cc;
        }
        VReadOnlyColumnConfiguration config = VTableFactory.eINSTANCE.createReadOnlyColumnConfiguration();
        cast.getColumnConfigurations().add((Object)config);
        return config;
    }

    public boolean isApplicable(EObject eObject) {
        return VTableControl.class.isInstance(eObject);
    }
}

