/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextAdapter;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.util.Disposable;
import org.eclipse.emf.ecp.internal.core.util.Element;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.util.AdapterProvider;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

public abstract class DefaultProvider
extends Element
implements InternalProvider {
    private final Disposable disposable = new Disposable(this){

        @Override
        protected void doDispose() {
            DefaultProvider.this.uiProvider = null;
            for (ECPRepository repository : ECPUtil.getECPRepositoryManager().getRepositories()) {
                if (!repository.getProvider().getName().equals(DefaultProvider.this.getName())) continue;
                DefaultProvider.this.handleLifecycle(repository, InternalProvider.LifecycleEvent.DISPOSE);
            }
            for (ECPProject project : ECPUtil.getECPProjectManager().getProjects()) {
                if (!project.getProvider().getName().equals(DefaultProvider.this.getName())) continue;
                DefaultProvider.this.handleLifecycle(project, InternalProvider.LifecycleEvent.DISPOSE);
            }
            DefaultProvider.this.doDispose();
        }
    };
    private String label;
    private String description;
    private AdapterProvider uiProvider;

    protected DefaultProvider(String name) {
        super(name);
        this.label = name;
        this.description = "";
    }

    @Override
    public final String getType() {
        return "Provider";
    }

    @Override
    public final InternalProvider getProvider() {
        return this;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setLabel(String label) {
        this.label = label;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final void setDescription(String description) {
        this.description = description;
    }

    @Override
    public final AdapterProvider getUIProvider() {
        return this.uiProvider;
    }

    @Override
    public final void setUIProvider(AdapterProvider uiProvider) {
        this.uiProvider = uiProvider;
    }

    @Override
    public final Set<InternalProject> getOpenProjects() {
        LinkedHashSet<InternalProject> result = new LinkedHashSet<InternalProject>();
        for (ECPProject project : ECPUtil.getECPProjectManager().getProjects()) {
            if (!project.isOpen() || !project.getProvider().equals(this)) continue;
            result.add((InternalProject)project);
        }
        return result;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Override
    public final void dispose() {
        this.disposable.dispose();
    }

    @Override
    public final void addDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.addDisposeListener(listener);
    }

    @Override
    public final void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.removeDisposeListener(listener);
    }

    protected void doDispose() {
    }

    @Override
    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        if (this.uiProvider != null) {
            return this.uiProvider.getAdapter(adaptable, adapterType);
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    @Override
    public EditingDomain createEditingDomain(InternalProject project) {
        CommandStack commandStack = this.createCommandStack(project);
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)InternalProvider.EMF_ADAPTER_FACTORY, commandStack);
        editingDomain.getResourceSet().eAdapters().add((Object)new ECPModelContextAdapter(project));
        return editingDomain;
    }

    protected CommandStack createCommandStack(InternalProject project) {
        return new BasicCommandStack();
    }

    @Override
    public boolean hasCreateRepositorySupport() {
        return true;
    }

    @Override
    public boolean isSlow(Object parent) {
        return false;
    }

    @Override
    public ECPContainer getModelContext(Object element) {
        ResourceSet resourceSet;
        ECPContainer context;
        if (element instanceof ECPContainer) {
            return (ECPContainer)element;
        }
        if (element instanceof ECPModelContextProvider) {
            return ((ECPModelContextProvider)element).getModelContext(element);
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            context = this.getModelContextFromAdapter((Notifier)eObject);
            if (context != null) {
                return context;
            }
            element = eObject.eResource();
        }
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            context = this.getModelContextFromAdapter((Notifier)resource);
            if (context != null) {
                return context;
            }
            element = resource.getResourceSet();
        }
        if (element instanceof ResourceSet && (context = this.getModelContextFromAdapter((Notifier)(resourceSet = (ResourceSet)element))) != null) {
            return context;
        }
        return null;
    }

    protected final ECPContainer getModelContextFromAdapter(Notifier notifier) {
        ECPModelContextAdapter adapter = (ECPModelContextAdapter)EcoreUtil.getAdapter((List)notifier.eAdapters(), ECPModelContextAdapter.class);
        if (adapter != null) {
            return adapter.getContext();
        }
        return null;
    }

    @Override
    public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
        if (parent == ECPUtil.getECPProjectManager()) {
            childrenList.addChildren(ECPUtil.getECPProjectManager().getProjects());
        } else if (parent == ECPUtil.getECPRepositoryManager()) {
            childrenList.addChildren(ECPUtil.getECPRepositoryManager().getRepositories());
        } else {
            ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)EMF_ADAPTER_FACTORY.adapt(parent, ITreeItemContentProvider.class);
            if (treeItemContentProvider != null) {
                Collection children = treeItemContentProvider.getChildren(parent);
                childrenList.addChildren(children);
            }
        }
    }

    @Override
    public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
        String providerClass = this.getClass().getSimpleName();
        String contextClass = context.getClass().getSimpleName();
        Activator.log(String.valueOf(providerClass) + " received " + (Object)((Object)event) + " for " + contextClass + " " + context);
    }

    @Override
    public Set<EPackage> getUnsupportedEPackages(Collection<EPackage> packages, InternalRepository repository) {
        return Collections.emptySet();
    }

    @Override
    public Iterator<EObject> getLinkElements(InternalProject project, EObject modelElement, EReference eReference) {
        return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)modelElement, (EClassifier)eReference.getEType()).iterator();
    }

    @Override
    public void doSave(InternalProject project) {
    }

    @Override
    public boolean isDirty(InternalProject project) {
        return false;
    }

    @Override
    public boolean modelExists(InternalProject project) {
        return true;
    }

    @Override
    public boolean hasCreateProjectWithoutRepositorySupport() {
        return false;
    }

    @Override
    public boolean contains(InternalProject project, Object object) {
        return false;
    }
}

