/*******************************************************************************
 * Copyright (c) 2011-2013 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Eugen Neufeld - initial API and implementation
 ******************************************************************************/
package org.eclipse.emf.ecp.ui.util;


/**
 * This interface can be extended in order to provide dynamic testers for the model element opener. So if you want to
 * check specific information of an EObject aside the EClass you should implement this.
 * 
 * @author Eugen Neufeld
 * 
 */
public interface ECPModelElementOpenTester {
	/**
	 * Return this whenever the opener can't open a specific element.
	 */
	int NOT_APPLICABLE = -1;

	/**
	 * This is called by the ECPHandlerHelper to check how well the corresponding {@link ECPModelElementOpener} can
	 * handle
	 * the current Obejct.
	 * The Tester with the highest result will be chosen. If the corresponding {@link ECPModelElementOpener} can't
	 * handle the EObject, the result should be {@link #NOT_APPLICABLE}.
	 * 
	 * @param eObject the {@link Object} to open
	 * @return an integer defining how fitting the corresponding opener is.
	 */
	int isApplicable(Object eObject);
}
