/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;

@EdaptOperation(identifier="replaceInheritanceByDelegation", label="Inheritance to Delegation", description="In the metamodel, inheritance from a super class is replaced by delegation to this class. More specifically, the super class is removed and a containment reference to this class is created. In the model, the contents associated to the super class are extracted to a separate instance of the super class.")
public class ReplaceInheritanceByDelegation
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class from which the super class is removed")
    public EClass subClass;
    @EdaptParameter(description="The super class to be removed")
    public EClass superClass;
    @EdaptParameter(description="The name of the reference to the super class")
    public String referenceName;

    @EdaptConstraint(restricts="superClass", description="The super class must be a super type of the sub class")
    public boolean checkSuperClass(EClass superClass) {
        return this.subClass.getESuperTypes().contains((Object)superClass);
    }

    public void execute(Metamodel metamodel, Model model) {
        this.subClass.getESuperTypes().remove((Object)this.superClass);
        EReference delegation = MetamodelFactory.newEReference((EClass)this.subClass, (String)this.referenceName, (EClass)this.superClass, (int)1, (int)1, (boolean)true);
        for (Instance instance : model.getAllInstances(this.subClass)) {
            Instance delegate = model.newInstance(this.superClass);
            instance.set((EStructuralFeature)delegation, (Object)delegate);
            for (EStructuralFeature feature : this.superClass.getEAllStructuralFeatures()) {
                delegate.set(feature, instance.unset(feature));
            }
            for (ReferenceSlot slot : new ArrayList(instance.getReferences())) {
                EReference reference = slot.getEReference();
                Instance source = slot.getInstance();
                if (!reference.getEReferenceType().isSuperTypeOf(this.superClass)) continue;
                if (reference.isMany()) {
                    source.remove((EStructuralFeature)reference, (Object)instance);
                    source.add((EStructuralFeature)reference, (Object)delegate);
                } else {
                    source.set((EStructuralFeature)reference, (Object)delegate);
                }
                if (!reference.isContainment()) continue;
                instance.unset((EStructuralFeature)delegation);
                model.delete(instance);
            }
        }
    }
}

