/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.List;
import org.eclipse.emf.edapt.declaration.Constraint;
import org.eclipse.emf.edapt.history.instantiation.ui.TableItemPopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ConstraintViewer
extends TableViewer {
    private final Image constraintImage;

    public ConstraintViewer(Composite parent) {
        super(parent, 68354);
        ImageDescriptor imageDescriptor = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"obj16/error_tsk.gif");
        this.constraintImage = imageDescriptor.createImage();
        this.init();
    }

    private void init() {
        final Table constraintTable = this.getTable();
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List constraints = (List)inputElement;
                return constraints.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ConstraintViewer.this.constraintImage;
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Constraint constraint = (Constraint)element;
                switch (columnIndex) {
                    case 0: {
                        return constraint.getDescription();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        constraintTable.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (constraintTable.getSelectionCount() > 0) {
                    TableItem tableItem = constraintTable.getSelection()[0];
                    ConstraintViewer.this.showDescription(tableItem);
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (constraintTable.getSelectionCount() > 0) {
                    TableItem tableItem = constraintTable.getSelection()[0];
                    ConstraintViewer.this.showDescription(tableItem);
                }
            }
        });
    }

    private void showDescription(TableItem tableItem) {
        Constraint constraint = (Constraint)tableItem.getData();
        TableItemPopupDialog dialog = new TableItemPopupDialog(tableItem, constraint.getDescription(), constraint.getName());
        dialog.open();
    }
}

