/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.PartAdapter;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.history.reconstruction.ui.DiffSelectionAdapter;
import org.eclipse.emf.edapt.history.recorder.ui.EcoreEditorDetector;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.NoChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConvergenceView
extends ViewPart
implements CommandStackListener,
ISelectionChangedListener {
    public static final String ID = ConvergenceView.class.getName();
    private ModelSash differenceSash;
    private ModelSash targetSash;
    private EcoreEditor editor;
    private Resource sourceResource;
    private Resource targetResource;
    private DiffSelectionAdapter selectionAdapter;
    private Mapping mapping;
    private boolean selecting = false;
    private boolean synchronization = true;
    private boolean refresh;
    private final IPartListener partListener = new PartAdapter(){

        public void partClosed(IWorkbenchPart part) {
            if (ConvergenceView.this.editor == part) {
                ConvergenceView.this.differenceSash.getStructureViewer().setInput(null);
                ConvergenceView.this.targetSash.getStructureViewer().setInput(null);
                ConvergenceView.this.detachOldEditor();
            }
        }
    };

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        this.differenceSash = new ModelSash((Composite)sash, 0);
        StructureTreeViewer differenceViewer = this.differenceSash.getStructureViewer();
        differenceViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)differenceViewer.getLabelProvider(), (ILabelDecorator)new Decorator()));
        this.targetSash = new ModelSash((Composite)sash, 0);
        this.targetSash.getStructureViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                if (ConvergenceView.this.selecting) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
                    EObject element = (EObject)selection.getFirstElement();
                    EObject source = ConvergenceView.this.mapping.getSource(element);
                    if (source != null) {
                        ConvergenceView.this.selecting = true;
                        ConvergenceView.this.editor.setSelectionToViewer(Collections.singleton(source));
                        ConvergenceView.this.selecting = false;
                    }
                }
            }
        });
        differenceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    System.out.println("DifferenViewer doubleclick, selection" + selection);
                }
            }
        });
        this.getSite().getPage().addPartListener(this.partListener);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Sync", 2){
            {
                this.setChecked(true);
                this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
                this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED_DISABLED"));
            }

            public void run() {
                ConvergenceView.this.setSynchronization(this.isChecked());
            }
        });
    }

    public void setFocus() {
        if (!this.differenceSash.isDisposed()) {
            this.differenceSash.setFocus();
        }
    }

    public void init(URI targetURI, EcoreEditor editor) {
        this.detachOldEditor();
        this.attachNewEditor(targetURI, editor);
    }

    private void detachOldEditor() {
        if (this.editor != null) {
            this.editor.getEditingDomain().getCommandStack().removeCommandStackListener((CommandStackListener)this);
            this.editor.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (!this.differenceSash.getStructureViewer().getTree().isDisposed()) {
                this.differenceSash.getStructureViewer().getTree().removeSelectionListener((SelectionListener)this.selectionAdapter);
            }
            this.editor = null;
        }
    }

    private void attachNewEditor(URI targetURI, EcoreEditor editor) {
        try {
            this.sourceResource = (Resource)editor.getEditingDomain().getResourceSet().getResources().get(0);
            ResourceSet resourceSet = ResourceUtils.loadResourceSet((URI)targetURI);
            this.targetResource = (Resource)resourceSet.getResources().get(0);
            this.editor = editor;
            this.editor.getEditingDomain().getCommandStack().addCommandStackListener((CommandStackListener)this);
            this.selectionAdapter = new DiffSelectionAdapter(editor.getViewer(), null, (Viewer)this.targetSash.getStructureViewer(), this.targetSash.getPropertiesViewer()){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ConvergenceView.this.selecting = true;
                    super.widgetSelected(e);
                    ConvergenceView.this.selecting = false;
                }
            };
            this.differenceSash.getStructureViewer().getTree().addSelectionListener((SelectionListener)this.selectionAdapter);
            this.editor.addSelectionChangedListener((ISelectionChangedListener)this);
            this.refresh();
            this.targetSash.getStructureViewer().setInput((Object)this.targetResource);
            this.targetSash.getStructureViewer().expandToLevel(2);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
        }
    }

    public void commandStackChanged(EventObject event) {
        if (!this.refresh && this.synchronization) {
            this.refresh();
        }
    }

    private void refresh() {
        this.refresh = true;
        this.differenceSash.getStructureViewer().expandToLevel(3);
    }

    private void addMarker(final Integer number) {
        final Release release = EcoreEditorDetector.getInstance().getListener(this.editor).getHistory().getLastRelease();
        ChangeCommand command = new ChangeCommand((Notifier)release){

            protected void doExecute() {
                NoChange marker = HistoryFactory.eINSTANCE.createNoChange();
                marker.setDescription(number.toString());
                release.getChanges().add((Object)marker);
            }
        };
        this.editor.getEditingDomain().getCommandStack().execute((Command)command);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        this.detachOldEditor();
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        EObject element;
        EObject target;
        IStructuredSelection selection;
        if (this.selecting) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject && (target = this.mapping.getTarget(element = (EObject)selection.getFirstElement())) != null) {
            this.selecting = true;
            this.targetSash.getStructureViewer().setSelection((ISelection)new StructuredSelection((Object)target), true);
            this.selecting = false;
        }
    }

    private Integer extractNumber(URI targetURI) {
        String name = targetURI.trimFileExtension().lastSegment();
        int index = name.indexOf(95);
        if (index >= 0 && (index = (name = name.substring(index + 1)).indexOf(46)) >= 0) {
            name = name.substring(index + 1);
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private void setSynchronization(boolean synchronization) {
        this.synchronization = synchronization;
        if (synchronization) {
            this.refresh();
        }
    }

    public ModelSash getDifferenceSash() {
        return this.differenceSash;
    }

    public class Decorator
    implements ILabelDecorator,
    IColorDecorator {
        private final Color red = new Color((Device)Display.getDefault(), 255, 0, 0);

        public Color decorateBackground(Object element) {
            return null;
        }

        public Color decorateForeground(Object element) {
            return null;
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.red.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

