/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.ui.MetamodelEditorViewBase;
import org.eclipse.emf.edapt.history.instantiation.ExecuteCommand;
import org.eclipse.emf.edapt.history.instantiation.ui.OperationSash;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edapt.history.recorder.ui.EcoreEditorDetector;
import org.eclipse.emf.edapt.internal.common.IExtentProvider;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OperationBrowser
extends MetamodelEditorViewBase
implements IExtentProvider {
    public static final String ID = "org.eclipse.emf.edapt.history.instantiation.view.operationsBrowser";
    private Button executeButton;
    private OperationSash operationSash;

    public OperationSash getOperationSash() {
        return this.operationSash;
    }

    protected void editorChanged(EcoreEditor oldEditor) {
        EcoreEditor newEditor;
        if (oldEditor != null) {
            this.setPartName("Operation Browser");
        }
        if ((newEditor = this.getEditor()) != null) {
            this.setPartName("Operation Browser - " + newEditor.getTitle());
            this.selectionChanged((IStructuredSelection)newEditor.getSelection());
        } else {
            this.operationSash.updateViewers(null);
            this.executeButton.setEnabled(false);
        }
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.operationSash = new OperationSash(parent, this){

            @Override
            public boolean updateConstraints(OperationInstance operationInstance) {
                boolean valid = super.updateConstraints(operationInstance);
                if (valid) {
                    OperationBrowser.this.executeButton.setEnabled(true);
                    OperationBrowser.this.executeButton.setFocus();
                } else {
                    OperationBrowser.this.executeButton.setEnabled(false);
                }
                return valid;
            }
        };
        this.operationSash.setLayoutData(new GridData(1808));
        this.getSite().setSelectionProvider((ISelectionProvider)this.operationSash.getOperationViewer());
        this.initButtons(parent);
    }

    private void initButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        this.executeButton = new Button(composite, 0);
        this.executeButton.setText("Execute");
        this.executeButton.setEnabled(false);
        this.executeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OperationBrowser.this.executeOperation();
            }
        });
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        this.operationSash.updateOperations(structuredSelection);
        this.executeButton.setEnabled(false);
    }

    public MetamodelExtent getExtent() {
        EcoreEditor editor = this.getEditor();
        EcoreEditorDetector detector = EcoreEditorDetector.getInstance();
        EditingDomainListener listener = detector.getListener(editor);
        if (listener != null) {
            return listener.getExtent();
        }
        Collection rootPackages = MetamodelUtils.getAllRootPackages((ResourceSet)this.getEditor().getEditingDomain().getResourceSet());
        return new MetamodelExtent(rootPackages);
    }

    public void setFocus() {
        this.operationSash.setFocus();
    }

    private void executeOperation() {
        OperationInstance operationInstance = this.operationSash.getSelectedOperation();
        MetamodelExtent extent = this.getExtent();
        if (!extent.isConsistent() && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Metamodel inconsistent", (String)"Metamodel inconsistent. Do you really want to execute this operation?")) {
            return;
        }
        ExecuteCommand command = new ExecuteCommand(operationInstance, extent);
        CommandStack commandStack = this.getEditor().getEditingDomain().getCommandStack();
        commandStack.execute((Command)command);
        if (!extent.isConsistent() && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Metamodel inconsistent", (String)"Metamodel inconsistent. Do you really want to keep the result of this operation?")) {
            commandStack.undo();
        }
        this.selectionChanged((IStructuredSelection)this.getEditor().getSelection());
    }
}

