/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation.action;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.jface.viewers.ISelection;

public class SubsequentChangesPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        ISelection selection = (ISelection)receiver;
        List changes = SelectionUtils.getSelectedElements((ISelection)selection);
        return this.isValid(changes);
    }

    private boolean isValid(List<Change> changes) {
        if (changes.isEmpty()) {
            return false;
        }
        Release release = SubsequentChangesPropertyTester.sort(changes);
        if (release == null) {
            return false;
        }
        int firstIndex = release.getChanges().indexOf((Object)changes.get(0));
        int lastIndex = release.getChanges().indexOf((Object)changes.get(changes.size() - 1));
        boolean valid = lastIndex - firstIndex + 1 == changes.size();
        return valid;
    }

    public static Release sort(List<? extends Change> changes) {
        final Release release = SubsequentChangesPropertyTester.getRelease(changes);
        if (release == null) {
            return null;
        }
        Collections.sort(changes, new Comparator<Change>(){

            @Override
            public int compare(Change c1, Change c2) {
                int i1 = release.getChanges().indexOf((Object)c1);
                int i2 = release.getChanges().indexOf((Object)c2);
                return new Integer(i1).compareTo(i2);
            }
        });
        return release;
    }

    public static Release getRelease(List<? extends Change> changes) {
        Change first = changes.get(0);
        if (!(first.eContainer() instanceof Release)) {
            return null;
        }
        Release release = (Release)first.eContainer();
        for (Change change : changes) {
            if (change.eContainer() == release) continue;
            return null;
        }
        return release;
    }
}

