/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.internal.BackupUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.ui.MigrationUIActivator;
import org.eclipse.emf.edapt.migration.ui.MigratorHandlerBase;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;

public class RestoreBackupHandler
extends MigratorHandlerBase {
    @Override
    protected void run(List<URI> backupURIs, Migrator migrator, Release release) {
        try {
            Metamodel metamodel = migrator.getMetamodel(release);
            BackupUtils.restore(backupURIs, (Metamodel)metamodel);
            for (URI backupURI : backupURIs) {
                IFile file = URIUtils.getFile((URI)backupURI);
                if (!file.exists()) continue;
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            for (IFile backupFile : this.getSelectedFiles()) {
                backupFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
    }
}

