/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.migration.CustomMigration;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;

public class BidirectionalChangesCustomMigration
extends CustomMigration {
    private List<Instance> root = new ArrayList<Instance>();
    private Map<Instance, Instance> forwardMapping = new HashMap<Instance, Instance>();
    private Map<Instance, Instance> backwardMapping = new HashMap<Instance, Instance>();
    private Model model;

    private void visitChange(Instance change) throws MigrationException {
        if (change.instanceOf("CompositeChange")) {
            EList children = change.getLinks("changes");
            for (Instance child : children) {
                this.visitChange(child);
            }
        } else if (change.instanceOf("MigrationChange")) {
            EList children = change.getLinks("changes");
            for (Instance child : children) {
                this.visitChange(child);
            }
        } else if (change.instanceOf("ContentChange")) {
            this.visitContentChange(change);
        } else if (change.instanceOf("ValueChange")) {
            this.visitValueChange(change);
        } else if (!change.instanceOf("NoChange")) {
            throw new MigrationException("Unknown change: " + change.getEClass().getName(), null);
        }
    }

    private void visitValueChange(Instance change) {
        if (change.instanceOf("Set")) {
            this.visitSet(change);
        } else if (change.instanceOf("Add")) {
            this.visitAdd(change);
        } else if (change.instanceOf("Remove")) {
            this.visitRemove(change);
        }
    }

    private void visitContentChange(Instance change) {
        if (change.instanceOf("Create")) {
            this.visitCreate(change);
        } else if (change.instanceOf("Move")) {
            this.visitMove(change);
        } else if (change.instanceOf("Delete")) {
            this.visitDelete(change);
        }
    }

    private void visitCreate(Instance change) {
        Model model = change.getType().getModel();
        Instance element = change.getLink("element");
        Instance reconstructed = model.newInstance(element.getEClass());
        this.map(element, reconstructed);
        Instance target = (Instance)change.get("target");
        if (target != null) {
            String referenceName = (String)change.get("referenceName");
            EStructuralFeature reference = target.getEClass().getEStructuralFeature(referenceName);
            this.getForward(target).add(reference, (Object)reconstructed);
        } else {
            this.root.add(reconstructed);
        }
        EList children = change.getLinks("changes");
        for (Instance child : children) {
            this.visitValueChange(child);
        }
    }

    private void visitMove(Instance change) {
        Instance element = (Instance)change.get("element");
        change.set("source", (Object)this.getBackward(this.getForward(element).getContainer()));
        Instance target = (Instance)change.get("target");
        String referenceName = (String)change.get("referenceName");
        EStructuralFeature reference = target.getEClass().getEStructuralFeature(referenceName);
        this.getForward(element).getContainer().remove(reference, (Object)this.getForward(element));
        this.getForward(target).add(reference, (Object)this.getForward(element));
    }

    private boolean contains(Instance containee, Instance container) {
        if (containee == null) {
            return false;
        }
        if (containee == container) {
            return true;
        }
        return this.contains(containee.getContainer(), container);
    }

    private void visitDelete(Instance change) {
        Instance element = this.getForward(change.getLink("element"));
        this.addRemoves(element, change);
        change.set("target", (Object)this.getBackward(element.getContainer()));
        change.set("referenceName", (Object)element.getContainerReference().getName());
        this.model.delete(element);
    }

    private void addRemoves(Instance element, Instance delete) {
        for (ReferenceSlot referenceSlot : element.getReferences()) {
            Instance source = referenceSlot.getInstance();
            if (this.contains(source, element) || this.contains(element, source)) continue;
            Model model = element.getType().getModel();
            Instance remove = model.newInstance("Remove");
            remove.set("element", (Object)this.getBackward(source));
            remove.set("featureName", (Object)referenceSlot.getEReference().getName());
            remove.set("referenceValue", (Object)this.getBackward(element));
            delete.getLinks("changes").add((Object)remove);
        }
        for (Instance child : element.getContents()) {
            this.addRemoves(child, delete);
        }
    }

    private void visitSet(Instance change) {
        Instance element = (Instance)change.get("element");
        String featureName = (String)change.get("featureName");
        EStructuralFeature feature = element.getEClass().getEStructuralFeature(featureName);
        if (feature instanceof EReference) {
            change.set("oldReferenceValue", (Object)this.getBackward((Instance)this.getForward(element).get(feature)));
            Instance referenceValue = change.getLink("referenceValue");
            this.getForward(element).set(feature, (Object)this.resolveForward(referenceValue));
        } else {
            EDataType type = ((EAttribute)feature).getEAttributeType();
            change.set("oldDataValue", (Object)EcoreUtil.convertToString((EDataType)type, (Object)this.getForward(element).get(feature)));
            String dataValue = (String)change.get("dataValue");
            this.getForward(element).set(feature, EcoreUtil.createFromString((EDataType)type, (String)dataValue));
        }
    }

    private void visitAdd(Instance change) {
        Instance element = (Instance)change.get("element");
        String featureName = (String)change.get("featureName");
        EStructuralFeature feature = element.getEClass().getEStructuralFeature(featureName);
        if (feature instanceof EReference) {
            Instance referenceValue = change.getLink("referenceValue");
            this.getForward(element).add(feature, (Object)this.resolveForward(referenceValue));
        } else {
            EDataType type = ((EAttribute)feature).getEAttributeType();
            String dataValue = (String)change.get("dataValue");
            this.getForward(element).add(feature, EcoreUtil.createFromString((EDataType)type, (String)dataValue));
        }
    }

    private void visitRemove(Instance change) {
        Instance element = (Instance)change.get("element");
        String featureName = (String)change.get("featureName");
        EStructuralFeature feature = element.getEClass().getEStructuralFeature(featureName);
        if (feature instanceof EReference) {
            Instance referenceValue = change.getLink("referenceValue");
            this.getForward(element).remove(feature, (Object)this.resolveForward(referenceValue));
        } else {
            EDataType type = ((EAttribute)feature).getEAttributeType();
            String dataValue = (String)change.get("dataValue");
            this.getForward(element).remove(feature, EcoreUtil.createFromString((EDataType)type, (String)dataValue));
        }
    }

    private Instance getForward(Instance instance) {
        return this.forwardMapping.get(instance);
    }

    private Instance resolveForward(Instance instance) {
        Instance forward = this.getForward(instance);
        if (forward == null) {
            return instance;
        }
        return forward;
    }

    private Instance getBackward(Instance instance) {
        return this.backwardMapping.get(instance);
    }

    private void map(Instance source, Instance target) {
        this.forwardMapping.put(source, target);
        this.backwardMapping.put(target, source);
    }

    public void migrateAfter(Model model, Metamodel metamodel) throws MigrationException {
        metamodel.setDefaultPackage("history");
        Instance history = (Instance)model.getInstances("History").get(0);
        for (Instance release : history.getLinks("releases")) {
            for (Instance change : release.getLinks("changes")) {
                this.visitChange(change);
            }
        }
        for (Instance r : this.root) {
            model.delete(r);
        }
    }
}

