/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.ReversableMap;
import org.eclipse.emf.edapt.common.TwoWayIdentityHashMap;
import org.eclipse.emf.edapt.history.reconstruction.MappingBase;

public class Mapping
extends MappingBase {
    private final ReversableMap<EObject, EObject> mapping = new TwoWayIdentityHashMap();

    public EObject getTarget(EObject source) {
        return (EObject)this.mapping.get((Object)source);
    }

    public EObject getSource(EObject target) {
        return (EObject)this.mapping.reverseGet((Object)target);
    }

    public void map(EObject source, EObject target) {
        if (this.getTarget(source) != null && this.getTarget(source) != target) {
            throw new IllegalArgumentException("Source element already mapped to different target element");
        }
        if (this.getSource(target) != null && this.getSource(target) != source) {
            throw new IllegalArgumentException("Target element already mapped to different source element");
        }
        this.mapping.put((Object)source, (Object)target);
    }

    public void unmap(EObject source) {
        this.mapping.remove((Object)source);
    }

    public boolean isMapped(EObject source, EObject target) {
        return this.getTarget(source) == target && this.getSource(target) == source;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (EObject key : this.mapping.keySet()) {
            EObject target = (EObject)this.mapping.get((Object)key);
            sb.append("map " + key + " to:" + target + "\n");
        }
        return sb.toString();
    }
}

