/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.FileUtils;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.BackupUtils;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.ui.MigrationUIActivator;
import org.eclipse.emf.edapt.migration.ui.MigratorHandlerBase;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateHandler
extends MigratorHandlerBase {
    @Override
    protected void run(final List<URI> modelURIs, final Migrator migrator, Release release) {
        try {
            final Metamodel metamodel = migrator.getMetamodel(release);
            final List backupURIs = BackupUtils.backup(modelURIs, (Metamodel)metamodel);
            final Release sourceRelease = release;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        migrator.migrateAndSave(modelURIs, sourceRelease, null, monitor);
                    }
                    catch (MigrationException e) {
                        LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
                        MigrateHandler.this.restoreBackup(metamodel, backupURIs);
                        MigrateHandler.this.showException(e);
                    }
                    MigrateHandler.this.refreshModels();
                }
            };
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
    }

    private void restoreBackup(Metamodel metamodel, List<URI> backupURIs) {
        try {
            BackupUtils.restore(backupURIs, (Metamodel)metamodel);
            for (URI backupURI : backupURIs) {
                FileUtils.delete((URI)backupURI);
            }
        }
        catch (IOException e1) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e1);
        }
    }

    private void showException(MigrationException e) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error during migration", (String)e.getMessage());
        URI location = e.getLocation();
        if (location != null) {
            this.showLocation(location);
        }
    }

    private void showLocation(URI location) {
        try {
            IFile file = URIUtils.getFile((URI)location);
            if (file != null && file.exists()) {
                String fileString = file.getLocation().toPortableString();
                IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileString);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                activePage.openEditor((IEditorInput)new FileEditorInput(file), descriptor.getId());
            }
        }
        catch (PartInitException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
    }

    private void refreshModels() {
        try {
            for (IFile modelFile : this.getSelectedFiles()) {
                modelFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
        }
    }
}

