/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.HashSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.TypeUtils;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.history.reconstruction.ReconstructorBase;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.InitializerChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.OperationChange;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.history.util.HistorySwitch;

public class HistoryValidator
extends ReconstructorBase {
    private ValidatorSwitch validatorSwitch;
    private Mapping mapping;
    private final java.util.Set<EObject> createdElements = new HashSet<EObject>();
    private boolean inFirstRelease;
    private boolean inMigrationChange;
    private boolean inOperationChange;
    private boolean inInitializerChange;

    public void init(Mapping mapping, MetamodelExtent extent) {
        this.mapping = mapping;
        this.validatorSwitch = new ValidatorSwitch();
    }

    public void startRelease(Release originalRelease) {
        this.inFirstRelease = originalRelease.isFirstRelease();
        this.reset();
    }

    public void startChange(Change originalChange) {
        if (this.canIgnore()) {
            originalChange.setBreaking(false);
            return;
        }
        originalChange.setBreaking((Boolean)this.validatorSwitch.doSwitch(originalChange));
        this.startIgnore(originalChange);
    }

    public void endChange(Change change) {
        this.endIgnore(change);
        if (this.canIgnore()) {
            return;
        }
        this.endUpdate(change);
    }

    private boolean canIgnore() {
        return this.inFirstRelease || this.inMigrationChange || this.inOperationChange || this.inInitializerChange;
    }

    private void startIgnore(Change change) {
        if (change instanceof MigrationChange) {
            this.inMigrationChange = true;
            change.setBreaking(false);
            this.reset();
        } else if (change instanceof OperationChange) {
            this.inOperationChange = true;
            change.setBreaking(false);
            this.reset();
        } else if (change instanceof InitializerChange) {
            this.inInitializerChange = true;
            change.setBreaking(false);
        }
    }

    private void endIgnore(Change change) {
        if (change instanceof MigrationChange) {
            this.inMigrationChange = false;
            this.reset();
        } else if (change instanceof OperationChange) {
            this.inOperationChange = false;
            this.reset();
        } else if (change instanceof InitializerChange) {
            this.inInitializerChange = false;
        }
    }

    private void endUpdate(Change change) {
        if (change instanceof Create) {
            Create createChild = (Create)change;
            EObject created = this.mapping.resolveTarget(createChild.getElement());
            this.created(created);
        } else if (change instanceof CompositeChange && !(change instanceof OperationChange)) {
            CompositeChange compositeChange = (CompositeChange)change;
            boolean breaking = false;
            for (PrimitiveChange primitiveChange : compositeChange.getChanges()) {
                breaking |= primitiveChange.isBreaking();
            }
            compositeChange.setBreaking(breaking);
            this.reset();
        }
    }

    private void created(EObject element) {
        this.createdElements.add(element);
    }

    private boolean isCreated(EObject element) {
        return this.createdElements.contains(element);
    }

    private void reset() {
        this.createdElements.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidatorSwitch
    extends HistorySwitch<Boolean> {
        private final EcorePackage p = EcorePackage.eINSTANCE;

        private ValidatorSwitch() {
        }

        @Override
        public Boolean caseSet(final Set set) {
            final EStructuralFeature feature = set.getFeature();
            EObject element = HistoryValidator.this.mapping.resolveTarget(set.getElement());
            if (HistoryValidator.this.isCreated(element)) {
                return false;
            }
            EcoreSwitch<Boolean> setValidatorSwitch = new EcoreSwitch<Boolean>(){

                public Boolean caseETypedElement(ETypedElement object) {
                    if (object instanceof EOperation) {
                        return false;
                    }
                    if (object instanceof EStructuralFeature && feature.isDerived()) {
                        return false;
                    }
                    switch (feature.getFeatureID()) {
                        case 3: {
                            boolean value = (Boolean)set.getValue();
                            if (!value) break;
                            return true;
                        }
                        case 5: {
                            int value = (Integer)set.getValue();
                            int oldValue = (Integer)set.getOldValue();
                            if (oldValue < 0) {
                                return true;
                            }
                            if (value < 0 || value >= oldValue) break;
                            return true;
                        }
                        case 8: {
                            if (set.getElement() instanceof EReference) {
                                EClass newValue;
                                EClass oldValue = (EClass)HistoryValidator.this.mapping.resolveTarget(set.getOldValue());
                                if (TypeUtils.ancestor((EClass)oldValue, (EClass)(newValue = (EClass)HistoryValidator.this.mapping.resolveTarget(set.getValue())))) break;
                                return true;
                            }
                            return true;
                        }
                    }
                    return null;
                }

                public Boolean caseEStructuralFeature(EStructuralFeature object) {
                    switch (feature.getFeatureID()) {
                        case 12: {
                            boolean value = (Boolean)set.getValue();
                            if (!value) break;
                            return true;
                        }
                    }
                    return null;
                }

                public Boolean caseEAttribute(EAttribute object) {
                    switch (feature.getFeatureID()) {
                        case 18: {
                            boolean value = (Boolean)set.getValue();
                            if (!value) break;
                            return true;
                        }
                    }
                    return null;
                }

                public Boolean caseEReference(EReference object) {
                    switch (feature.getFeatureID()) {
                        case 18: {
                            return true;
                        }
                        case 21: {
                            return true;
                        }
                    }
                    return null;
                }

                public Boolean caseEClass(EClass eClass) {
                    switch (feature.getFeatureID()) {
                        case 8: {
                            boolean value;
                            if (feature != ValidatorSwitch.this.p.getEClass_Abstract() || !(value = ((Boolean)set.getValue()).booleanValue()) || eClass.isInterface()) break;
                            return true;
                        }
                        case 9: {
                            boolean value = (Boolean)set.getValue();
                            if (!value || eClass.isAbstract()) break;
                            return true;
                        }
                    }
                    return null;
                }

                public Boolean defaultCase(EObject object) {
                    return false;
                }
            };
            return (Boolean)setValidatorSwitch.doSwitch(element);
        }

        @Override
        public Boolean caseRemove(Remove remove) {
            EStructuralFeature feature = remove.getFeature();
            EObject element = HistoryValidator.this.mapping.resolveTarget(remove.getElement());
            if (HistoryValidator.this.isCreated(element)) {
                return false;
            }
            if (element instanceof EClass) {
                switch (feature.getFeatureID()) {
                    case 10: {
                        EClass eClass = (EClass)remove.getValue();
                        if (eClass.getEAllStructuralFeatures().isEmpty()) break;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Boolean caseDelete(Delete delete) {
            EObject element = HistoryValidator.this.mapping.resolveTarget(delete.getElement());
            if (HistoryValidator.this.isCreated(element)) {
                return false;
            }
            if (element instanceof EStructuralFeature) {
                return true;
            }
            if (!delete.getChanges().isEmpty()) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean caseMove(Move move) {
            EObject element = move.getElement();
            if (element instanceof EStructuralFeature) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean defaultCase(EObject object) {
            return false;
        }
    }
}

