/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edapt.history.reconstruction.ModelAssert;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.internal.BackupUtils;
import org.eclipse.emf.edapt.internal.migration.internal.Persistency;
import org.eclipse.emf.edapt.internal.migration.internal.PrintStreamProgressMonitor;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.Metamodel;

public abstract class MigrationTestBase
extends TestCase {
    public void testMigration(URI migratorURI, URI modelURI, URI expectedTargetModelURI, URI expectedTargetMetamodelURI, IClassLoader loader) throws MigrationException, IOException {
        Migrator migrator = new Migrator(migratorURI, loader);
        this.testMigration(migrator, modelURI, expectedTargetModelURI, expectedTargetMetamodelURI);
    }

    public void testMigration(Migrator migrator, URI modelURI, URI expectedTargetModelURI, URI expectedTargetMetamodelURI) throws MigrationException, IOException {
        this.testMigration(migrator, modelURI, expectedTargetModelURI, expectedTargetMetamodelURI, 0);
    }

    public void testMigration(Migrator migrator, URI modelURI, URI expectedTargetModelURI, URI expectedTargetMetamodelURI, int expectedNumber) throws MigrationException, IOException {
        Set releases = migrator.getRelease(modelURI);
        MigrationTestBase.assertTrue((releases.size() >= 1 ? 1 : 0) != 0);
        Release release = HistoryUtils.getMinimumRelease((Set)releases);
        URI targetModelURI = this.rename(migrator, modelURI, release);
        migrator.migrateAndSave(Collections.singletonList(targetModelURI), release, null, (IProgressMonitor)new PrintStreamProgressMonitor(System.out));
        Metamodel expectedMetamodel = Persistency.loadMetamodel((URI)expectedTargetMetamodelURI);
        EObject actualModel = (EObject)((Resource)ResourceUtils.loadResourceSet((URI)targetModelURI, (List)expectedMetamodel.getEPackages()).getResources().get(0)).getContents().get(0);
        EObject expectedModel = (EObject)((Resource)ResourceUtils.loadResourceSet((URI)expectedTargetModelURI, (List)expectedMetamodel.getEPackages()).getResources().get(0)).getContents().get(0);
        ModelAssert.assertDifference((EObject)expectedModel, (EObject)actualModel, (int)expectedNumber);
    }

    private URI rename(Migrator migrator, URI modelURI, Release release) throws IOException {
        Metamodel metamodel = migrator.getMetamodel(release);
        List<URI> modelURIs = Collections.singletonList(modelURI);
        List<URI> backupURIs = this.rename(modelURIs, metamodel);
        return backupURIs.get(0);
    }

    protected List<URI> rename(List<URI> modelURIs, Metamodel metamodel) throws IOException {
        List backupURIs = BackupUtils.copy(modelURIs, (Metamodel)metamodel, (BackupUtils.URIMapper)new BackupUtils.URIMapper(){

            public URI map(URI uri) {
                String name = uri.lastSegment().replace(".", "_migrated.");
                return uri.trimSegments(1).appendSegment(name);
            }
        });
        return backupURIs;
    }

    public void testMigration(URI modelURI, URI expectedTargetModelURI, URI expectedTargetMetamodelURI, int expectedDifferences) throws MigrationException, IOException {
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURI);
        Migrator migrator = MigratorRegistry.getInstance().getMigrator(nsURI);
        MigrationTestBase.assertNotNull((Object)migrator);
        this.testMigration(migrator, modelURI, expectedTargetModelURI, expectedTargetMetamodelURI, expectedDifferences);
    }
}

