/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReleaseWizardPage
extends WizardPage {
    private final String source;
    private Text sourceText;
    private Text targetText;
    private Button updateButton;

    protected ReleaseWizardPage(String pageName, String description, ImageDescriptor titleImage, String source) {
        super(pageName, pageName, titleImage);
        this.setDescription(description);
        this.source = source;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label sourceLabel = new Label(composite, 0);
        sourceLabel.setText("Label to match:");
        this.sourceText = new Text(composite, 2048);
        this.sourceText.setText(this.source);
        this.sourceText.setLayoutData((Object)new GridData(768));
        this.initSourceText(this.sourceText);
        Label targetLabel = new Label(composite, 0);
        targetLabel.setText("Label to replace with:");
        this.targetText = new Text(composite, 2048);
        this.targetText.setLayoutData((Object)new GridData(768));
        this.initTargetText(this.targetText);
        Label updateLabel = new Label(composite, 0);
        updateLabel.setText("Update namespace URI:");
        this.updateButton = new Button(composite, 32);
        this.updateButton.setSelection(true);
        this.initUpdateButton(this.updateButton);
        this.setControl((Control)composite);
        this.checkIfPageComplete();
    }

    private void initSourceText(Text sourceText) {
        sourceText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private void initTargetText(Text targetText) {
        targetText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private void initUpdateButton(Button updateButton) {
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReleaseWizardPage.this.checkIfPageComplete();
            }
        });
    }

    private void checkIfPageComplete() {
        if (!this.updateButton.getSelection()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        if (this.sourceText.getText().isEmpty()) {
            this.setErrorMessage("Label to match may not be empty");
            this.setPageComplete(false);
            return;
        }
        if (this.targetText.getText().isEmpty()) {
            this.setErrorMessage("Label to replace may not be empty");
            this.setPageComplete(false);
            return;
        }
        if (this.sourceText.getText().equals(this.targetText.getText())) {
            this.setErrorMessage("Source and target label may not be equal");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getSource() {
        return this.sourceText.getText();
    }

    public String getTarget() {
        return this.targetText.getText();
    }

    public boolean isUpdate() {
        return this.updateButton.getSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.targetText.setFocus();
        }
    }

    public void setTarget(String target) {
        this.targetText.setText(target);
        this.checkIfPageComplete();
    }
}

