/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation.action;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.ui.EditingDomainHandlerBase;
import org.eclipse.emf.edapt.common.ui.HandlerUtils;
import org.eclipse.emf.edapt.history.presentation.action.JavaUIUtils;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IType;

public class CreateMigrationHandler
extends EditingDomainHandlerBase {
    protected Object execute(EditingDomain domain, ExecutionEvent event) {
        EObject element = (EObject)HandlerUtils.getSelectedElement((ExecutionEvent)event, EObject.class);
        IType javaType = JavaUIUtils.createCustomMigration(element);
        if (javaType != null) {
            this.createMigration(element, javaType.getFullyQualifiedName(), domain);
        }
        return null;
    }

    private void createMigration(EObject element, String elementName, EditingDomain domain) {
        Change change;
        Release release = null;
        int index = -1;
        if (element instanceof Release) {
            release = (Release)element;
        } else if (element instanceof Change) {
            change = (Change)element;
            release = change.getRelease();
            index = release.getChanges().indexOf((Object)change);
        }
        change = HistoryFactory.eINSTANCE.createMigrationChange();
        change.setMigration(elementName);
        CreateChildCommand command = new CreateChildCommand(domain, (EObject)release, (EStructuralFeature)HistoryPackage.eINSTANCE.getRelease_Changes(), (Object)change, index, Collections.emptyList());
        domain.getCommandStack().execute((Command)command);
    }
}

