/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.eventTypes;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import org.jboss.cdi.tck.tests.event.eventTypes.AbstractEvent;
import org.jboss.cdi.tck.tests.event.eventTypes.ComplexEvent;
import org.jboss.cdi.tck.tests.event.eventTypes.GeneralEvent;

@Dependent
public class EventTypeFamilyObserver {
    private static int objectEventQuantity = 0;
    private static int generalEventQuantity = 0;
    private static int abstractEventQuantity = 0;
    private static int complexEventQuantity = 0;

    public void observeObject(@Observes Object event) {
        if (event instanceof ComplexEvent) {
            ++objectEventQuantity;
        }
    }

    public void observeGeneralEvent(@Observes GeneralEvent event) {
        ++generalEventQuantity;
    }

    public void observeAbstractEvent(@Observes AbstractEvent event) {
        ++abstractEventQuantity;
    }

    public void observeComplexEvent(@Observes ComplexEvent event) {
        ++complexEventQuantity;
    }

    public int getGeneralEventQuantity() {
        return generalEventQuantity;
    }

    public int getAbstractEventQuantity() {
        return abstractEventQuantity;
    }

    public int getComplexEventQuantity() {
        return complexEventQuantity;
    }

    public int getObjectEventQuantity() {
        return objectEventQuantity;
    }

    public int getTotalEventsObserved() {
        return objectEventQuantity + generalEventQuantity + abstractEventQuantity + complexEventQuantity;
    }

    public void reset() {
        objectEventQuantity = 0;
        generalEventQuantity = 0;
        abstractEventQuantity = 0;
        complexEventQuantity = 0;
    }
}

