/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.event.fires.Item;
import org.jboss.cdi.tck.tests.event.fires.Lifted;
import org.jboss.cdi.tck.tests.event.fires.MiniBar;

@RequestScoped
public class Billing {
    private boolean active = false;
    private int charge = 0;
    private int miniBarValue = 0;
    private Set<Item> itemsPurchased = new HashSet<Item>();

    public void billForItem(@Observes @Lifted Item item) {
        if (this.itemsPurchased.add(item)) {
            this.charge += item.getPrice();
        }
    }

    public int getCharge() {
        return this.charge;
    }

    public int getMiniBarValue() {
        return this.miniBarValue;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate(@Observes @Any MiniBar minibar) {
        this.active = true;
        this.miniBarValue = 0;
        for (Item item : minibar.getItems()) {
            this.miniBarValue += item.getPrice();
        }
    }

    public void reset() {
        this.active = false;
        this.itemsPurchased.clear();
        this.charge = 0;
    }
}

