/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.producer;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.producer.Bird;
import org.jboss.cdi.tck.tests.full.extensions.producer.BirdCage;
import org.jboss.cdi.tck.tests.full.extensions.producer.Cat;
import org.jboss.cdi.tck.tests.full.extensions.producer.CatFoodDish;
import org.jboss.cdi.tck.tests.full.extensions.producer.CheckableInjectionTarget;
import org.jboss.cdi.tck.tests.full.extensions.producer.Cow;
import org.jboss.cdi.tck.tests.full.extensions.producer.Dog;
import org.jboss.cdi.tck.tests.full.extensions.producer.DogBed;
import org.jboss.cdi.tck.tests.full.extensions.producer.DogProducer;
import org.jboss.cdi.tck.tests.full.extensions.producer.LitterBox;
import org.jboss.cdi.tck.tests.full.extensions.producer.Noisy;
import org.jboss.cdi.tck.tests.full.extensions.producer.ProducerProcessor;
import org.jboss.cdi.tck.tests.full.extensions.producer.Quiet;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ProducerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withExtension(ProducerProcessor.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="ba"), @SpecAssertion(section="injectiontarget", id="bb"), @SpecAssertion(section="injectiontarget", id="bc")})
    public void testProduceAndInjectCallsInitializerAndConstructor() {
        Cat.reset();
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(null);
        Cat instance = (Cat)injectionTarget.produce(ctx);
        assert (Cat.isConstructorCalled());
        injectionTarget.inject((Object)instance, ctx);
        assert (Cat.isInitializerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="bd"), @SpecAssertion(section="injectiontarget", id="be")})
    public void testInterceptorAndDecoratorStackBuilt() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(null);
        Cat instance = (Cat)injectionTarget.produce(ctx);
        Assert.assertEquals((int)instance.foo(), (int)11);
        Assert.assertEquals((String)instance.saySomething(), (String)"Meow meow");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="c")})
    public void testDisposeDoesNothing() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        Cat cat = this.getContextualReference(Cat.class, new Annotation[0]);
        injectionTarget.dispose((Object)cat);
        cat.ping();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="da")})
    public void testGetInjectionPointsForFields() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        assert (injectionTarget.getInjectionPoints().size() == 3);
        boolean injectionPointPresent = false;
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            if (!injectionPoint.getType().equals(CatFoodDish.class)) continue;
            injectionPointPresent = true;
        }
        assert (injectionPointPresent);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="db"), @SpecAssertion(section="injectiontarget", id="dc")})
    public void testGetInjectionPointsForConstructorAndInitializer() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        assert (injectionTarget.getInjectionPoints().size() == 3);
        boolean constructorIPPresent = false;
        boolean initializerMethodIPPresent = false;
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            if (injectionPoint.getType().equals(LitterBox.class)) {
                constructorIPPresent = true;
            }
            if (!injectionPoint.getType().equals(Bird.class)) continue;
            initializerMethodIPPresent = true;
        }
        assert (initializerMethodIPPresent);
        assert (constructorIPPresent);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="eaa"), @SpecAssertion(section="process_producer", id="aa"), @SpecAssertion(section="process_producer", id="ba"), @SpecAssertion(section="process_producer", id="ca"), @SpecAssertion(section="process_producer", id="da"), @SpecAssertion(section="bean_discovery_steps", id="jb")})
    public void testProduceCallsProducerMethod() {
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Noisy.Literal());
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (DogProducer.isNoisyDogProducerCalled());
        assert (dog.getColor().equals("White"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_producer", id="e"), @SpecAssertion(section="process_producer", id="ga")})
    public void testSetProducerOverridesProducer() {
        ProducerProcessor.reset();
        assert (this.getContextualReference(Cow.class, new Noisy.Literal()) instanceof Cow);
        assert (ProducerProcessor.isOverriddenCowProducerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="eba"), @SpecAssertion(section="process_producer", id="ab"), @SpecAssertion(section="process_producer", id="bb"), @SpecAssertion(section="process_producer", id="cb"), @SpecAssertion(section="process_producer", id="db"), @SpecAssertion(section="bean_discovery_steps", id="jb")})
    public void testProduceAccessesProducerField() {
        Producer<Dog> producer = ProducerProcessor.getQuietDogProducer();
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Quiet.Literal());
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (dog.getColor().equals("Black"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="faa")})
    public void testProducerForMethodDisposesProduct() {
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Noisy.Literal());
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (DogProducer.isNoisyDogProducerCalled());
        producer.dispose((Object)dog);
        assert (DogProducer.isNoisyDogDisposerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="g")})
    public void testInjectionPointsForProducerMethod() {
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        DogProducer.reset();
        assert (producer.getInjectionPoints().size() == 1);
        assert (((InjectionPoint)producer.getInjectionPoints().iterator().next()).getType().equals(DogBed.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="i"), @SpecAssertion(section="type_discovery_steps", id="c"), @SpecAssertion(section="process_injection_target", id="aaa"), @SpecAssertion(section="injectiontarget_ee", id="a")})
    public void testInjectionTargetInject() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Bean dogBean = (Bean)this.getCurrentManager().getBeans(Dog.class, new Annotation[0]).iterator().next();
        CreationalContext dogCreationalContext = this.getCurrentManager().createCreationalContext((Contextual)dogBean);
        Dog dog = (Dog)dogBean.create(dogCreationalContext);
        dog.setDogBone(null);
        injectionTarget.inject((Object)dog, dogCreationalContext);
        assert (dog.getDogBone() != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="j"), @SpecAssertion(section="injectiontarget_ee", id="b")})
    public void testInjectionTargetPostConstruct() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Dog dog = this.getContextualReference(Dog.class, new Noisy.Literal());
        Dog.setPostConstructCalled(false);
        injectionTarget.postConstruct((Object)dog);
        assert (Dog.isPostConstructCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="k"), @SpecAssertion(section="injectiontarget_ee", id="c")})
    public void testInjectionTargetPreDestroy() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Dog dog = this.getContextualReference(Dog.class, new Noisy.Literal());
        Dog.setPreDestroyCalled(false);
        injectionTarget.preDestroy((Object)dog);
        assert (Dog.isPreDestroyCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target", id="bb"), @SpecAssertion(section="process_injection_target", id="ea")})
    public void testSettingInjectionTargetReplacesIt() {
        CheckableInjectionTarget.setInjectCalled(false);
        this.getContextualReference(BirdCage.class, new Annotation[0]);
        assert (CheckableInjectionTarget.isInjectCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target", id="aba")})
    public void testGetAnnotatedTypeOnProcessInjectionTarget() {
        assert (ProducerProcessor.getDogAnnotatedType() != null);
        assert (ProducerProcessor.getDogAnnotatedType().getBaseType().equals(Dog.class));
    }
}

