/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle;

import jakarta.enterprise.inject.Specializes;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle.Bream;
import org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle.Cod;
import org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle.Lion;
import org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle.MountainLion;
import org.jboss.cdi.tck.tests.full.implementation.simple.lifecycle.Tame;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class SimpleBeanLifecycleTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new Tame.Literal();

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanLifecycleTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="specialize_managed_bean", id="ac")})
    public void testSpecializedBeanExtendsManagedBean() {
        assert (MountainLion.class.getAnnotation(Specializes.class) != null);
        Bean<Lion> bean = null;
        Bean<Lion> specializedBean = null;
        for (Bean<Lion> lionBean : this.getBeans(Lion.class, TAME_LITERAL)) {
            if (lionBean.getBeanClass().equals(Lion.class)) {
                bean = lionBean;
                continue;
            }
            if (!lionBean.getBeanClass().equals(MountainLion.class)) continue;
            specializedBean = lionBean;
        }
        assert (bean == null);
        assert (specializedBean != null);
        assert (specializedBean.getBeanClass().getSuperclass().equals(Lion.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="b")})
    public void testSerializeRequestScoped() throws Exception {
        Cod codInstance = this.getContextualReference(Cod.class, new Annotation[0]);
        byte[] bytes = this.passivate(codInstance);
        Object object = this.activate(bytes);
        codInstance = (Cod)object;
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)codInstance));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="b")})
    public void testSerializeSessionScoped() throws Exception {
        Bream instance = this.getContextualReference(Bream.class, new Annotation[0]);
        byte[] bytes = this.passivate(instance);
        Object object = this.activate(bytes);
        instance = (Bream)object;
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)instance));
    }
}

