/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.invocation;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.invocation.AlmightyInterceptor;
import org.jboss.cdi.tck.tests.interceptors.invocation.Missile;
import org.jboss.cdi.tck.tests.interceptors.invocation.MissileObserver;
import org.jboss.cdi.tck.tests.interceptors.invocation.Rye;
import org.jboss.cdi.tck.tests.interceptors.invocation.Watcher;
import org.jboss.cdi.tck.tests.interceptors.invocation.Wheat;
import org.jboss.cdi.tck.tests.interceptors.invocation.WheatProducer;
import org.jboss.cdi.tck.util.DependentInstance;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptorInvocationTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorInvocationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method", id="a"), @SpecAssertion(section="bean_discovery_steps", id="g"), @SpecAssertion(section="biz_method", id="aa")})
    public void testManagedBeanIsIntercepted() {
        AlmightyInterceptor.reset();
        Missile missile = this.getContextualReference(Missile.class, new Annotation[0]);
        missile.fire();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertNotNull((Object)missile.getWarhead());
        AlmightyInterceptor.reset();
        Watcher watcher = this.getContextualReference(Watcher.class, new Annotation[0]);
        watcher.ping();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method", id="ad"), @SpecAssertion(section="initializer_methods", id="f")})
    public void testInitializerMethodsNotIntercepted() {
        AlmightyInterceptor.reset();
        Missile missile = this.getContextualReference(Missile.class, new Annotation[0]);
        Assert.assertFalse((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)missile.initCalled());
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="biz_method", id="ia")
    public void testProducerMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        this.getContextualReference(Wheat.class, new Annotation[0]);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="biz_method", id="ic")
    public void testDisposerMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        DependentInstance<Wheat> bean = this.newDependentInstance(Wheat.class, new Annotation[0]);
        Wheat instance = bean.get();
        Assert.assertNotNull((Object)instance);
        AlmightyInterceptor.methodIntercepted = false;
        bean.destroy();
        Assert.assertTrue((boolean)WheatProducer.destroyed);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="biz_method", id="ie")
    public void testObserverMethodsAreIntercepted() {
        AlmightyInterceptor.reset();
        this.getCurrentManager().getEvent().select(Missile.class, new Annotation[0]).fire((Object)new Missile());
        Assert.assertTrue((boolean)MissileObserver.observed);
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="biz_method", id="j")
    public void testLifecycleCallbacksAreIntercepted() {
        AlmightyInterceptor.reset();
        Rye rye = this.getContextualReference(Rye.class, new Annotation[0]);
        rye.ping();
        Assert.assertTrue((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="biz_method", id="m"), @SpecAssertion(section="biz_method", id="g")})
    public void testObjectMethodsAreNotIntercepted() {
        AlmightyInterceptor.reset();
        this.getContextualReference(Missile.class, new Annotation[0]).toString();
        Assert.assertFalse((boolean)AlmightyInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)AlmightyInterceptor.lifecycleCallbackIntercepted);
    }
}

