/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent;

import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Transactional;

@Interceptor
@Transactional
@Priority(value=2000)
public class TransactionalInterceptor {
    private static boolean destroyed;

    @AroundInvoke
    Object intercept(InvocationContext ctx) throws Exception {
        return ctx.proceed();
    }

    @PreDestroy
    void preDestroy(InvocationContext ctx) {
        try {
            destroyed = true;
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDestroyed() {
        return destroyed;
    }

    public static void reset() {
        destroyed = false;
    }
}

