/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Full;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionBean;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.AppBean;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.ManagedExecutorDefinitionOnEJBServlet;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.ManagedExecutorDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.ManagedExecutorDefinitionWebBean;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Full
@RunAsClient
public class ManagedExecutorDefinitionFullTests
extends TestClient {
    @ArquillianResource(value=ManagedExecutorDefinitionServlet.class)
    private URL baseURL;
    @ArquillianResource(value=ManagedExecutorDefinitionOnEJBServlet.class)
    private URL ejbContextURL;
    @TestName
    private String testname;

    @Deployment(name="ManagedExecutorDefinitionTests")
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ManagedExecutorDefinitionTests_web.war")).addPackages(true, new String[]{Common.PACKAGE.CONTEXT.getPackageName(), Common.PACKAGE.CONTEXT_PROVIDERS.getPackageName()})).addClasses(new Class[]{AppBean.class, ManagedExecutorDefinitionServlet.class, ManagedExecutorDefinitionOnEJBServlet.class, ContextServiceDefinitionServlet.class})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()});
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ManagedExecutorDefinitionTests_ejb.jar")).addPackages(false, new Package[]{ManagedExecutorDefinitionFullTests.class.getPackage()})).deleteClasses(new Class[]{AppBean.class, ManagedExecutorDefinitionWebBean.class, ManagedExecutorDefinitionServlet.class, ManagedExecutorDefinitionOnEJBServlet.class, ContextServiceDefinitionServlet.class})).addClasses(new Class[]{ContextServiceDefinitionInterface.class, ContextServiceDefinitionBean.class});
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ManagedExecutorDefinitionTests.ear")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Override
    protected String getServletPath() {
        return "ManagedExecutorDefinitionServlet";
    }

    @Assertion(id="GIT:154", strategy="ManagedExecutorService submits an action to run asynchronously as a CompletionStage. Dependent stages can be chained to the CompletionStage, and all stages run with the thread context of the thread from which they were created, per ManagedExecutorDefinition config.")
    public void testAsyncCompletionStage() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Asynchronous method that returns CompletableFuture")
    public void testAsynchronousMethodReturnsCompletableFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Asynchronous method that returns CompletionStage")
    public void testAsynchronousMethodReturnsCompletionStage() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Asynchronous method that returns void")
    public void testAsynchronousMethodVoidReturnType() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/224", version="3.0.0")
    @Assertion(id="GIT:154", strategy="ManagedExecutorService creates a completed CompletableFuture to which async dependent stages can be chained. The dependent stages all run with the thread context of the thread from which they were created, per ManagedExecutorDefinition config.")
    public void testCompletedFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedExecutorService can create a contextualized copy of an unmanaged CompletableFuture.")
    public void testCopyCompletableFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Use another managed executor from ManagedExecutorDefinition that was defined in an EJB")
    public void testCopyCompletableFutureEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedExecutorDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ManagedExecutorService creates an incomplete CompletableFuture to which dependent stages can be chained. The CompletableFuture can be completed from another thread lacking the same context, but the dependent stages all run with the thread context of the thread from which they were created, per ManagedExecutorDefinition config.")
    public void testIncompleteFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Use managed executor from ManagedExecutorDefinition that was defined in an EJB")
    public void testIncompleteFutureEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedExecutorDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ManagedExecutorDefinition with all attributes configured")
    public void testManagedExecutorDefinitionAllAttributes() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedExecutorDefinition with minimal attributes can run multiple async tasks concurrently and uses java:comp/DefaultContextService to determine context propagation and clearing.")
    public void testManagedExecutorDefinitionDefaults() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when future is completed.")
    public void testScheduledAsynchCompletedFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when a non-null result is returned.")
    public void testScheduledAsynchCompletedResult() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when an exception is thrown.")
    public void testScheduledAsynchCompletedExceptionally() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure overlapping scheduled asynchronous methods are skipped.")
    public void testScheduledAsynchOverlapSkipping() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods ignore the max-async configuration. Ensure scheduled asynchronous methods honor cleared context configuration")
    public void testScheduledAsynchIgnoresMaxAsync() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods choose closest execution time when multiple schedules are provided. Ensure scheduled asynchronous methods honor propogated context configuration")
    public void testScheduledAsynchWithMultipleSchedules() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are not executed when an invalid JNDI name is provided.")
    public void testScheduledAsynchWithInvalidJNDIName() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods with void return type stop execution via completable future or exception.")
    public void testScheduledAsynchVoidReturn() {
        this.runTest(this.baseURL, this.testname);
    }
}

