/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.SkippedException;

import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.enterprise.concurrent.SkippedException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
public class SkippedExceptionTests {
    @Deployment(name="SkippedExceptionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{SkippedExceptionTests.class.getPackage()});
    }

    @Assertion(id="JAVADOC:42", strategy="Constructs an SkippedException.")
    public void skippedExceptionNoArgTest() {
        SkippedException thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException();
        });
        Assertions.assertNull((Object)thrown.getMessage());
    }

    @Assertion(id="JAVADOC:43", strategy="Constructs an SkippedException.")
    public void skippedExceptionStringTest() {
        String expected = "thisisthedetailmessage";
        SkippedException thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException("thisisthedetailmessage");
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertEquals((Object)"thisisthedetailmessage", (Object)thrown.getMessage());
    }

    @Assertion(id="JAVADOC:45", strategy="Constructs an SkippedException.")
    public void skippedExceptionThrowableTest() {
        Throwable expected = new Throwable("thisisthethrowable");
        SkippedException thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(expected);
        });
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)expected, (Object)thrown.getCause());
        Throwable expectedNull = null;
        thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(expectedNull);
        });
        Assertions.assertNull((Object)thrown.getCause());
    }

    @Assertion(id="JAVADOC:44", strategy="Constructs an SkippedException.")
    public void skippedExceptionStringThrowableTest() {
        String sExpected = "thisisthedetailmessage";
        String sExpectedNull = null;
        Throwable tExpected = new Throwable("thisisthethrowable");
        Throwable tExpectedNull = null;
        SkippedException thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(sExpected, tExpected);
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)sExpected, (Object)thrown.getMessage());
        Assertions.assertEquals((Object)tExpected, (Object)thrown.getCause());
        thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(sExpected, tExpectedNull);
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)sExpected, (Object)thrown.getMessage());
        thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(sExpectedNull, tExpected);
        });
        Assertions.assertNull((Object)thrown.getMessage());
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)tExpected, (Object)thrown.getCause());
        thrown = (SkippedException)Assertions.assertThrows(SkippedException.class, () -> {
            throw new SkippedException(sExpectedNull, tExpectedNull);
        });
        Assertions.assertNull((Object)thrown.getMessage());
        Assertions.assertNull((Object)thrown.getCause());
    }
}

