/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.fixed.counter;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;

public final class StaticCounter {
    private static AtomicInteger count = new AtomicInteger(0);

    private StaticCounter() {
    }

    public static int getCount() {
        return count.get();
    }

    public static void inc() {
        count.incrementAndGet();
    }

    public static void reset() {
        count.set(0);
    }

    public static void waitTill(int expected) {
        StaticCounter.waitTill(expected, "Expected count " + expected + " within timeout.");
    }

    public static void waitTill(int expected, String message) {
        Assertions.assertTimeoutPreemptively((Duration)TestConstants.waitTimeout, () -> {
            while (expected != StaticCounter.getCount()) {
                Wait.sleep(TestConstants.pollInterval);
            }
        }, (String)message);
    }
}

