/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet.ProxyCreatorServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.servlet.WorkInterfaceServlet;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
@RunAsClient
public class ContextPropagationServletTests
extends TestClient {
    private static final String APP_NAME_PROXY = "ContextPropagationServletTests.Proxy";
    private static final String APP_NAME_WORK = "ContextPropagationServletTests.Work";
    private static final String APP_NAME_DESERIALIZE = "ContextPropagationServletTests.Deserialize";
    @TestName
    private String testname;
    @ArquillianResource
    @OperateOnDeployment(value="ContextPropagationServletTests.Proxy")
    private URL baseURL;
    @ArquillianResource
    @OperateOnDeployment(value="ContextPropagationServletTests.Work")
    private URL workInterfaceURL;

    @Deployment(name="ContextPropagationServletTests.Proxy")
    public static WebArchive createDeployment1() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Proxy.war")).addPackages(true, new Package[]{ContextPropagationServletTests.class.getPackage()})).deleteClass(WorkInterfaceServlet.class)).addAsWebInfResource(ContextPropagationServletTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Deployment(name="ContextPropagationServletTests.Work")
    public static WebArchive createDeployment2() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Work.war")).addPackages(true, new Package[]{ContextPropagationServletTests.class.getPackage()})).deleteClass(ProxyCreatorServlet.class);
    }

    @Deployment(name="ContextPropagationServletTests.Deserialize")
    public static WebArchive createDeployment3() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Deserialize.war")).addPackages(true, new Package[]{ContextPropagationServletTests.class.getPackage()})).deleteClasses(new Class[]{ProxyCreatorServlet.class, WorkInterfaceServlet.class});
    }

    @Override
    protected String getServletPath() {
        return "ProxyCreatorServlet";
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:78 SPEC:82 SPEC:84", strategy="Create proxy in servlet and pass it to other servlet in other web module, then verify JNDI Context.")
    public void testJNDIContextInServlet() {
        URL proxyURL = URLBuilder.get().withBaseURL(this.workInterfaceURL).withPaths("WorkInterfaceServlet").build();
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.baseURL).withPaths(this.getServletPath()).withTestName(this.testname);
        Properties props = new Properties();
        props.put("proxyURL", proxyURL.toString());
        props.put("testMethod", this.testname);
        String resp = this.runTestWithResponse(requestURL, props);
        Assertions.assertNotNull((Object)"Response should not be null", (String)resp);
        this.assertStringInResponse(this.testname + " failed to get correct result.", "JNDIContextWeb", resp.trim());
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:78 SPEC:82 SPEC:84", strategy="Create proxy in servlet and pass it into other servlet in other web module, then verify classloader.")
    public void testClassloaderInServlet() {
        URL proxyURL = URLBuilder.get().withBaseURL(this.workInterfaceURL).withPaths("WorkInterfaceServlet").build();
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.baseURL).withPaths(this.getServletPath()).withTestName(this.testname);
        Properties props = new Properties();
        props.put("proxyURL", proxyURL.toString());
        props.put("testMethod", this.testname);
        String resp = this.runTestWithResponse(requestURL, props);
        Assertions.assertNotNull((Object)"Response should not be null", (String)resp);
        this.assertStringInResponse(this.testname + " failed to get correct result.", "ConcurrentResultOkay", resp.trim());
    }
}

