/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.inheritedapi;

import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.common.tasks.CommonTasks;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Web
@Common(value={Common.PACKAGE.TASKS, Common.PACKAGE.FIXED_COUNTER})
public class InheritedAPITests {
    @Resource(lookup="java:comp/DefaultManagedExecutorService")
    private ManagedExecutorService executor;

    @Deployment(name="InheritedAPITests")
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @BeforeEach
    public void reset() {
        StaticCounter.reset();
    }

    @Assertion(id="SPEC:10.2; SPEC:13; SPEC:13.1; SPEC:13.2", strategy="Test basic function for ManagedExecutorService: execute")
    public void testExecute() {
        try {
            this.executor.execute((Runnable)new CounterRunnableTask());
            StaticCounter.waitTill(1);
        }
        finally {
            StaticCounter.reset();
        }
    }

    @Assertion(id="SPEC:14; SPEC:14.1; SPEC:14.2; SPEC:14.3", strategy="Test basic function for ManagedExecutorService: submit")
    public void testSubmit() throws Exception {
        Future result = this.executor.submit((Callable)new CommonTasks.SimpleCallable());
        Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
        result = this.executor.submit((Runnable)new CommonTasks.SimpleRunnable());
        Wait.waitForTaskComplete(result);
        result = this.executor.submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
        Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
    }

    @Assertion(id="SPEC:14.4; SPEC:6.1; SPEC:6.2; SPEC:8", strategy="Test basic function for ManagedExecutorService: invokeAny")
    public void testInvokeAny() {
        try {
            ArrayList<CommonTasks.SimpleArgCallable> taskList = new ArrayList<CommonTasks.SimpleArgCallable>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            Integer result = (Integer)this.executor.invokeAny(taskList);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
            result = (Integer)this.executor.invokeAny(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assertions.assertThrows(TimeoutException.class, () -> {
            ArrayList<CommonTasks.SimpleCallable> taskList = new ArrayList<CommonTasks.SimpleCallable>();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            this.executor.invokeAny(taskList, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
        });
    }

    @Assertion(id="SPEC:8.1; SPEC:9; SPEC:10; SPEC:10.2; SPEC:12; SPEC:19; SPEC:27", strategy="Test basic function for ManagedExecutorService: invokeAll")
    public void testInvokeAll() {
        List resultList;
        ArrayList<Callable<Integer>> taskList;
        try {
            taskList = new ArrayList<Callable<Integer>>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            resultList = this.executor.invokeAll(taskList);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
            resultList = this.executor.invokeAll(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            resultList = this.executor.invokeAll(taskList, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitTillFutureThrowsException(each, CancellationException.class);
            }
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }
}

