/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ManagedScheduleExecutorDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ReqBean;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;

@WebServlet(value={"/ManagedScheduledExecutorDefinitionOnEJBServlet"})
public class ManagedScheduledExecutorDefinitionOnEJBServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Inject
    private ReqBean reqBean;
    @Resource
    private UserTransaction tx;
    @EJB
    private ManagedScheduleExecutorDefinitionInterface managedScheduleExecutorDefinitionBean;
    @EJB
    private ContextServiceDefinitionInterface contextServiceDefinitionBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionAllAttributesEJB() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/EJBScheduledExecutorA");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        try {
            IntContext.set(33);
            executor.execute(task);
            executor.runAsync(task);
            executor.submit(task);
            executor.submit(task, (Object)"TaskResult");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run an async task.");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 2 async tasks concurrently.");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 3 async tasks concurrently.");
            Assertions.assertEquals((Integer)((Integer)results.poll(1L, TimeUnit.SECONDS)), null, (String)"ManagedScheduledExecutorService with maxAsync=3 must not run 4 async tasks concurrently.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 4th task after 1st completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionDefaultsEJB() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)this.managedScheduleExecutorDefinitionBean.doLookup("java:comp/concurrent/EJBScheduledExecutorC");
        CountDownLatch blocker = new CountDownLatch(1);
        CountDownLatch allTasksRunning = new CountDownLatch(4);
        Callable<Integer> txCallable = () -> {
            allTasksRunning.countDown();
            UserTransaction trans = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            int initialStatus = trans.getStatus();
            trans.begin();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            finally {
                trans.rollback();
            }
            return initialStatus;
        };
        Function<String, Object> lookupFunction = jndiName -> {
            allTasksRunning.countDown();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                return (ManagedScheduledExecutorService)this.managedScheduleExecutorDefinitionBean.doLookup((String)jndiName);
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
        };
        try {
            Future txFuture1 = executor.submit(txCallable);
            Future txFuture2 = executor.submit(txCallable);
            CompletionStage lookupFuture1 = executor.completedFuture((Object)"java:comp/concurrent/EJBScheduledExecutorC").thenApplyAsync(lookupFunction);
            CompletionStage lookupFuture2 = executor.completedFuture((Object)"java:module/concurrent/ScheduledExecutorB").thenApplyAsync(lookupFunction);
            Assertions.assertTrue((boolean)allTasksRunning.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedScheduledExecutorService without maxAsync must be able to run async tasks concurrently.");
            blocker.countDown();
            int status = (Integer)txFuture1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from first async Callable task per java:comp/concurrent/EJBScheduledExecutorC configuration.");
            status = (Integer)txFuture2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from second async Callable task per java:comp/concurrent/EJBScheduledExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture1).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first async Function per java:comp/concurrent/EJBScheduledExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture2).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second async Function per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        this.tx.begin();
        try {
            int status = (Integer)executor.getContextService().contextualCallable(txCallable).call();
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from inline contextual Callable per java:comp/concurrent/EJBScheduledExecutorC configuration.");
        }
        finally {
            this.tx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteFutureMSEEJB() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/EJBScheduledExecutorA");
        StringBuilder results = new StringBuilder();
        try {
            IntContext.set(91);
            StringContext.set("testIncompleteFutureMSE_EJB-1");
            CompletableFuture stage1a = executor.newIncompleteFuture();
            CompletableFuture stage1b = executor.newIncompleteFuture();
            IntContext.set(92);
            CompletionStage stage2 = stage1a.thenAcceptBothAsync((CompletionStage)stage1b, (part1, part2) -> {
                try {
                    ManagedScheduledExecutorService mes = (ManagedScheduledExecutorService)InitialContext.doLookup(part1 + "/" + part2);
                    results.append("Application context ").append(mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
                String s = StringContext.get();
                results.append(";StringContext ").append((String)("".equals(s) ? "cleared" : "incorrect:" + s));
            });
            IntContext.set(93);
            CompletionStage stage3 = ((CompletableFuture)stage2).runAfterBothAsync((CompletionStage)stage1b, () -> {
                int i = IntContext.get();
                results.append(";IntContext ").append((String)(i == 93 ? "propagated" : "incorrect:" + i));
            });
            stage1a.complete("java:app");
            stage1b.complete("concurrent/EJBScheduledExecutorA");
            Assertions.assertEquals(((CompletableFuture)stage3).join(), null, (String)"CompletableFuture with Void return type must return null from join.");
            String result = results.toString();
            Assertions.assertEquals((Object)result, (Object)"Application context propagated;StringContext cleared;IntContext propagated", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }
}

