/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.read.only;

import ee.jakarta.tck.data.framework.read.only.NaturalNumber;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbers;
import ee.jakarta.tck.data.framework.read.only.Populator;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class NaturalNumbersPopulator
implements Populator<NaturalNumbers> {
    public static NaturalNumbersPopulator get() {
        return new NaturalNumbersPopulator();
    }

    @Override
    public boolean isPopulated(NaturalNumbers repo) {
        return repo.countAll() == 100L;
    }

    @Override
    public void populationLogic(NaturalNumbers repo) {
        ArrayList dictonary = new ArrayList();
        IntStream.range(1, 101).forEach(id -> {
            NaturalNumber inst = new NaturalNumber();
            boolean isOne = id == 1;
            boolean isOdd = id % 2 == 1;
            long sqrRoot = NaturalNumbersPopulator.squareRoot(id);
            boolean isPrime = isOdd ? NaturalNumbersPopulator.isPrime(id, sqrRoot) : id == 2;
            inst.setId(id);
            inst.setOdd(isOdd);
            inst.setNumBitsRequired(NaturalNumbersPopulator.bitsRequired(id));
            inst.setNumType(isOne ? NaturalNumber.NumberType.ONE : (isPrime ? NaturalNumber.NumberType.PRIME : NaturalNumber.NumberType.COMPOSITE));
            inst.setFloorOfSquareRoot(sqrRoot);
            dictonary.add(inst);
        });
        repo.saveAll(dictonary);
    }

    private static Short bitsRequired(int value) {
        return (short)(Math.floor(Math.log(value) / Math.log(2.0)) + 1.0);
    }

    private static long squareRoot(int value) {
        return (long)Math.floor(Math.sqrt(value));
    }

    private static boolean isPrime(int value, long largestPossibleFactor) {
        if (value == 1) {
            return false;
        }
        int i = 2;
        while ((long)i <= largestPossibleFactor) {
            if (value % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

