/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.BasicJAnnotatable;
import org.jboss.jdeparser.EnumConstantJClassDef;
import org.jboss.jdeparser.EnumJClassDef;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JClassItem;
import org.jboss.jdeparser.JEnumConstant;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class ImplJEnumConstant
extends BasicJAnnotatable
implements JEnumConstant,
JClassItem {
    private final EnumJClassDef classDef;
    private final String name;
    private ArrayList<AbstractJExpr> args;
    private EnumConstantJClassDef body;

    ImplJEnumConstant(EnumJClassDef classDef, String name) {
        this.classDef = classDef;
        this.name = name;
    }

    EnumJClassDef getClassDef() {
        return this.classDef;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JEnumConstant arg(JExpr expr) {
        if (this.args == null) {
            this.args = new ArrayList();
        }
        this.args.add((AbstractJExpr)expr);
        return this;
    }

    @Override
    public JClassDef body() {
        return this.body != null ? this.body : (this.body = new EnumConstantJClassDef(this));
    }

    @Override
    public JExpr[] arguments() {
        return this.args.toArray(new JExpr[this.args.size()]);
    }

    void writeDirect(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        if (this.args == null || this.args.isEmpty()) {
            if (writer.getFormat().hasOption(FormatPreferences.Opt.ENUM_EMPTY_PARENS)) {
                writer.write(Tokens$.PUNCT.PAREN.OPEN);
                writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_CALL_EMPTY);
                writer.write(Tokens$.PUNCT.PAREN.CLOSE);
            }
        } else {
            writer.write(Tokens$.PUNCT.PAREN.OPEN);
            writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION);
            Iterator<AbstractJExpr> iterator = this.args.iterator();
            if (iterator.hasNext()) {
                writer.write(iterator.next());
                while (iterator.hasNext()) {
                    writer.write(Tokens$.PUNCT.COMMA);
                    writer.write(FormatPreferences.Space.AFTER_COMMA);
                    writer.write(iterator.next());
                }
            }
            writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION);
            writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        }
        if (this.body != null) {
            writer.write(FormatPreferences.Space.BEFORE_BRACE_CLASS);
            this.body.write(writer);
        }
    }

    @Override
    public JClassItem.Kind getItemKind() {
        return JClassItem.Kind.ENUM_CONSTANT;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean hasAllModifiers(int mods) {
        return false;
    }

    @Override
    public boolean hasAnyModifier(int mods) {
        return false;
    }
}

