/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.sanity;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AssertFailure
extends RuntimeException {
    private String threadDump = this.dumpThreads();

    public AssertFailure(String string, Throwable throwable) {
        super(string, throwable);
    }

    public AssertFailure(String string) {
        super(string);
    }

    public AssertFailure() {
    }

    public String getThreadDump() {
        return this.threadDump;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        printStream.println(this.threadDump);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.println(this.threadDump);
    }

    private boolean supportsThreadDump() {
        try {
            Thread.class.getMethod("getAllStackTraces", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private String dumpThreads() {
        Method method;
        Object object;
        if (!this.supportsThreadDump()) {
            return "(Skipping thread dump because it is not supported on JVM 1.4)";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        try {
            object = Class.forName("org.apache.derby.shared.common.sanity.ThreadDump");
            method = ((Class)object).getMethod("getStackDumpString", new Class[0]);
        }
        catch (Exception exception) {
            printWriter.println("Failed to load class/method required to generate a thread dump:");
            exception.printStackTrace(printWriter);
            return stringWriter.toString();
        }
        try {
            object = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    return method.invoke(null, (Object[])null);
                }
            });
            printWriter.print("---------------\nStack traces for all live threads:");
            printWriter.println("\n" + (String)object);
            printWriter.println("---------------");
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof InvocationTargetException && throwable.getCause() instanceof AccessControlException) {
                printWriter.println("(Skipping thread dump because of insufficient permissions:\n" + throwable.getCause() + ")\n");
            }
            printWriter.println("\nAssertFailure tried to do a thread dump, but there was an error:");
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

