/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.optional.utils.ToolUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public abstract class SimpleJsonUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray toJSON(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        JSONArray jSONArray = new JSONArray();
        try {
            while (resultSet.next()) {
                JSONObject jSONObject = new JSONObject();
                for (int i = 1; i <= n; ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    Object object = SimpleJsonUtils.getLegalJsonValue(resultSet.getObject(i));
                    jSONObject.put((Object)string, object);
                }
                jSONArray.add((Object)jSONObject);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return jSONArray;
    }

    public static JSONArray readArray(Reader reader) throws SQLException {
        JSONParser jSONParser = new JSONParser();
        Object object = null;
        try {
            object = jSONParser.parse(reader);
        }
        catch (Throwable throwable) {
            throw ToolUtilities.wrap(throwable);
        }
        if (object == null || !(object instanceof JSONArray)) {
            throw new SQLException("Document is not a JSON array.");
        }
        return (JSONArray)object;
    }

    public static JSONArray readArrayFromString(String string) throws SQLException {
        if (string == null) {
            string = "";
        }
        return SimpleJsonUtils.readArray(new StringReader(string));
    }

    public static JSONArray readArrayFromStream(InputStream inputStream, String string) throws SQLException {
        try {
            JSONArray jSONArray = SimpleJsonUtils.readArray(new InputStreamReader(inputStream, string));
            return jSONArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ToolUtilities.wrap(unsupportedEncodingException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw ToolUtilities.wrap(iOException);
            }
        }
    }

    public static JSONArray readArrayFromFile(String string, String string2) throws SQLException {
        FileInputStream fileInputStream = null;
        final String string3 = string;
        try {
            fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(string3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw ToolUtilities.wrap(privilegedActionException);
        }
        return SimpleJsonUtils.readArrayFromStream(fileInputStream, string2);
    }

    public static JSONArray readArrayFromURL(String string, String string2) throws SQLException {
        InputStream inputStream = null;
        final String string3 = string;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException, MalformedURLException {
                    URL uRL = new URL(string3);
                    return uRL.openStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw ToolUtilities.wrap(privilegedActionException);
        }
        return SimpleJsonUtils.readArrayFromStream(inputStream, string2);
    }

    public static Clob arrayToClob(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        return new HarmonySerialClob(jSONArray.toJSONString());
    }

    private static Object getLegalJsonValue(Object object) throws SQLException {
        if (object == null || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof String || object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            return ((Number)object).longValue();
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            return SimpleJsonUtils.formatBytes(blob.getBytes(1L, (int)blob.length()));
        }
        if (object instanceof byte[]) {
            return SimpleJsonUtils.formatBytes((byte[])object);
        }
        return object.toString();
    }

    private static String formatBytes(byte[] byArray) {
        return StringUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length);
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }
}

