/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class EjbEntityDescriptor
extends EjbDescriptor {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "Entity";
    public static final String BEAN_PERSISTENCE = "Bean";
    public static final String CONTAINER_PERSISTENCE = "Container";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected String persistenceType;
    protected boolean isReentrant;
    protected String primaryKeyClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbEntityDescriptor.class);
    static Logger _logger = DOLUtils.getDefaultLogger();

    public EjbEntityDescriptor() {
    }

    public EjbEntityDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbEntityDescriptor) {
            EjbEntityDescriptor entity = (EjbEntityDescriptor)other;
            this.persistenceType = entity.persistenceType;
            this.isReentrant = entity.isReentrant;
            this.primaryKeyClassName = entity.primaryKeyClassName;
        }
    }

    public String getEjbTypeForDisplay() {
        return "EntityBean";
    }

    public void setTransactionType(String transactionType) {
        if (!CONTAINER_PERSISTENCE.equals(transactionType) && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionentitybeancanonlyhavecntnrtxtype", "Entity beans can only have Container transaction type. The type was being set to {0}", new Object[]{transactionType}));
        }
        super.setTransactionType(transactionType);
    }

    @Override
    public String getContainerFactoryQualifier() {
        return "EntityContainerFactory";
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public String getReentrant() {
        return this.isReentrant() ? TRUE : FALSE;
    }

    public void setReentrant(String reentrantString) {
        if (TRUE.equalsIgnoreCase(reentrantString)) {
            this.setReentrant(true);
            return;
        }
        if (FALSE.equalsIgnoreCase(reentrantString)) {
            this.setReentrant(false);
            return;
        }
        if (Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionstringnotlegalvalue", "{0} is not a legal value for entity reentrancy", new Object[]{reentrantString}));
        }
    }

    public void setReentrant(boolean isReentrant) {
        this.isReentrant = isReentrant;
    }

    public String getPersistenceType() {
        if (this.persistenceType == null) {
            this.persistenceType = BEAN_PERSISTENCE;
        }
        return this.persistenceType;
    }

    public void setPersistenceType(String persistenceType) {
        boolean isValidChange;
        boolean bl = isValidChange = BEAN_PERSISTENCE.equals(persistenceType) || CONTAINER_PERSISTENCE.equals(persistenceType);
        if (!isValidChange && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionpersistenceisnotallowedtype", "{0} is not an allowed persistence type", new Object[]{persistenceType}));
        }
        this.persistenceType = persistenceType;
    }

    public String getPrimaryKeyClassName() {
        if (this.primaryKeyClassName == null) {
            this.primaryKeyClassName = Object.class.getName();
        }
        return this.primaryKeyClassName;
    }

    public void setPrimaryKeyClassName(String primaryKeyClassName) {
        this.primaryKeyClassName = primaryKeyClassName;
    }

    public String getType() {
        return TYPE;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Entity descriptor");
        toStringBuffer.append("\n isReentrant ").append(this.isReentrant);
        toStringBuffer.append("\n primaryKeyClassName ").append(this.primaryKeyClassName);
        toStringBuffer.append("\n persistenceType ").append(this.persistenceType);
    }
}

