/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.eis.mappings.EISOneToManyMappingHelper;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.EISOneToManyQueryBasedValueHolder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.w3c.dom.Element;

public class EISOneToManyMapping
extends CollectionMapping
implements EISMapping {
    protected boolean isForeignKeyRelationship = false;
    protected transient List<DatabaseField> targetForeignKeyFields;
    protected transient List<DatabaseField> sourceForeignKeyFields = new ArrayList<DatabaseField>(1);
    protected transient Map<DatabaseField, DatabaseField> sourceForeignKeysToTargetKeys;
    protected DatabaseField foreignKeyGroupingElement;

    public EISOneToManyMapping() {
        this.targetForeignKeyFields = new ArrayList<DatabaseField>(1);
        this.sourceForeignKeysToTargetKeys = new HashMap<DatabaseField, DatabaseField>(2);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    @Override
    public boolean isEISMapping() {
        return true;
    }

    @Override
    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetKeyField) {
        this.getSourceForeignKeyFields().add(sourceForeignKeyField);
        this.getTargetForeignKeyFields().add(targetKeyField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String sourceForeignKeyFieldName, String targetKeyFieldName) {
        this.addForeignKeyField(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetKeyFieldName));
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean isForeignKeyRelationship) {
        this.isForeignKeyRelationship = isForeignKeyRelationship;
    }

    public DatabaseField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public void setForeignKeyGroupingElement(String name) {
        this.setForeignKeyGroupingElement(new DatabaseField(name));
    }

    @Override
    public boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    @Override
    public ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    @Override
    public void setDeleteAllCall(Call call) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setCall(call);
        this.setDeleteAllQuery(deleteAllQuery);
        this.setHasCustomDeleteAllQuery(true);
    }

    public void setForeignKeyGroupingElement(DatabaseField field) {
        this.foreignKeyGroupingElement = field;
    }

    public List<DatabaseField> getSourceForeignKeyFields() {
        return this.sourceForeignKeyFields;
    }

    public void setSourceForeignKeyFields(List<DatabaseField> fields) {
        this.sourceForeignKeyFields = fields;
        if (fields != null && !fields.isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public List<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public void setTargetForeignKeyFields(List<DatabaseField> fields) {
        this.targetForeignKeyFields = fields;
    }

    public Map<DatabaseField, DatabaseField> getSourceForeignKeysToTargetKeys() {
        return this.sourceForeignKeysToTargetKeys;
    }

    public void setSourceForeignKeysToTargetKeys(Map<DatabaseField, DatabaseField> sourceToTargetKeyFields) {
        this.sourceForeignKeysToTargetKeys = sourceToTargetKeyFields;
        if (sourceToTargetKeyFields != null && !sourceToTargetKeyFields.keySet().isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    @Override
    public boolean hasInverseConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getForeignKeyGroupingElement() == null && this.getSourceForeignKeysToTargetKeys().size() > 1) {
            throw EISException.groupingElementRequired();
        }
        if (this.getForeignKeyGroupingElement() != null) {
            DatabaseField field = this.getDescriptor().buildField(this.getForeignKeyGroupingElement());
            this.setForeignKeyGroupingElement(field);
        }
        this.initializeSourceForeignKeysToTargetKeys();
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        }
        this.initializeDeleteAllQuery();
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        if (this.getSourceForeignKeysToTargetKeys().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField foreignKey : this.getSourceForeignKeysToTargetKeys().keySet()) {
            DatabaseField targetKey = this.getSourceForeignKeysToTargetKeys().get(foreignKey);
            Expression expression = ((Expression)builder).getField(targetKey).equal(builder.getParameter(foreignKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    protected void initializeSourceForeignKeysToTargetKeys() throws DescriptorException {
        DatabaseField field;
        int i;
        if (this.getSourceForeignKeyFields().size() != this.getTargetForeignKeyFields().size()) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        for (i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
            field = this.getReferenceDescriptor().buildField(this.getTargetForeignKeyFields().get(i));
            this.getTargetForeignKeyFields().set(i, field);
        }
        for (i = 0; i < this.getSourceForeignKeyFields().size(); ++i) {
            field = this.getDescriptor().buildField(this.getSourceForeignKeyFields().get(i));
            this.getSourceForeignKeyFields().set(i, field);
            this.getSourceForeignKeysToTargetKeys().put(field, this.getTargetForeignKeyFields().get(i));
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
        }
    }

    @Override
    public void preInitialize(AbstractSession session) {
        super.preInitialize(session);
        if (((EISDescriptor)this.descriptor).isXMLFormat() && this.foreignKeyGroupingElement != null && !(this.foreignKeyGroupingElement instanceof XMLField)) {
            XMLField newField = new XMLField(this.foreignKeyGroupingElement.getName());
            this.foreignKeyGroupingElement = newField;
        }
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isForeignKeyRelationship()) {
            return super.shouldObjectModifyCascadeToParts(query);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        if (this.hasCustomDeleteAllQuery()) {
            this.deleteAll(query, referenceObjects);
        } else {
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(referenceObjects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        } else {
            this.deleteAll(query);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            UnitOfWorkChangeSet uowChangeSet;
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            if (query.getSession().isUnitOfWork() && (uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet()) != null) {
                writeQuery.setObjectChangeSet((ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object));
            }
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    public Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSet;
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object targetElement = null;
            targetElement = mergeManager.shouldMergeChangesIntoDistributedCache() ? objectChangeSet.getTargetVersionOfSourceObject(mergeManager, mergeManager.getSession(), true) : objectChangeSet.getUnitOfWorkClone();
            mergeManager.mergeChanges(targetElement, objectChangeSet, targetSession);
        }
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    public Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        ObjectBuilder objectBuilder = session.getDescriptor(element).getObjectBuilder();
        return objectBuilder.createObjectChangeSet(element, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
    }

    protected Object buildElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return ((ObjectChangeSet)changeSet).getTargetVersionOfSourceObject(mergeManager, targetSession);
    }

    public Object buildElementFromElement(Object element, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            UnitOfWorkChangeSet uowChangeSet;
            ObjectChangeSet objectChangeSet = null;
            if (mergeManager.getSession().isUnitOfWork() && (uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()) != null) {
                objectChangeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(element);
            }
            Object mergeElement = mergeManager.getObjectToMerge(element, this.referenceDescriptor, targetSession);
            mergeManager.mergeChanges(mergeElement, objectChangeSet, targetSession);
        }
        return mergeManager.getTargetVersionOfSourceObject(element, this.referenceDescriptor, targetSession);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (policy.shouldValidateExample()) {
            throw QueryException.unsupportedMappingQueryByExample(queryObject.getClass().getName(), this);
        }
        return null;
    }

    public Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSet;
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    @Override
    public Object clone() {
        EISOneToManyMapping clone = (EISOneToManyMapping)super.clone();
        clone.setSourceForeignKeysToTargetKeys((Map)((HashMap)this.getSourceForeignKeysToTargetKeys()).clone());
        return clone;
    }

    @Override
    protected List<DatabaseField> collectFields() {
        if (this.isForeignKeyRelationship()) {
            if (this.getForeignKeyGroupingElement() != null) {
                ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(1);
                fields.add(this.getForeignKeyGroupingElement());
                return fields;
            }
            return NO_FIELDS;
        }
        return NO_FIELDS;
    }

    public boolean compareElements(Object element1, Object element2, AbstractSession session) {
        Object primaryKey2;
        if (!this.isForeignKeyRelationship()) {
            return false;
        }
        Object primaryKey1 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(element1, session);
        if (!primaryKey1.equals(primaryKey2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(element2, session))) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return session.compareObjects(element1, element2);
        }
        return true;
    }

    public boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return !this.getContainerPolicy().compareKeys(element, session);
    }

    public boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        return element1 == element2;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getAttributeValueFromObject(clone) != null && !this.isAttributeValueInstantiatedOrChanged(clone)) {
                return null;
            }
            return new EISOneToManyMappingHelper(this).compareForChange(clone, backup, owner, session);
        }
        return super.compareForChange(clone, backup, owner, session);
    }

    @Override
    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            return new EISOneToManyMappingHelper(this).compareObjects(object1, object2, session);
        }
        return super.compareObjects(object1, object2, session);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord chgRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.isForeignKeyRelationship()) {
            new EISOneToManyMappingHelper(this).mergeChangesIntoObject(target, chgRecord, source, mergeManager, targetSession);
            return;
        }
        super.mergeChangesIntoObject(target, chgRecord, source, mergeManager, targetSession);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.isForeignKeyRelationship()) {
            new EISOneToManyMappingHelper(this).mergeIntoObject(target, isTargetUnInitialized, source, mergeManager, targetSession);
            return;
        }
        super.mergeIntoObject(target, isTargetUnInitialized, source, mergeManager, targetSession);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        new EISOneToManyMappingHelper(this).simpleAddToCollectionChangeRecord(referenceKey, changeSetToAdd, changeSet, session);
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        new EISOneToManyMappingHelper(this).simpleRemoveFromCollectionChangeRecord(referenceKey, changeSetToRemove, changeSet, session);
    }

    protected void deleteAll(DeleteObjectQuery query, Object referenceObjects) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(referenceObjects, query.getSession()));
    }

    protected void deleteAll(DeleteObjectQuery query) throws DatabaseException {
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        this.deleteAll(query, referenceObjects);
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    protected AbstractRecord extractKeyRowFromReferenceObject(Object object, AbstractSession session, AbstractRecord parentRecord) {
        AbstractRecord result;
        int size = this.sourceForeignKeyFields.size();
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat()) {
            Element newNode = XPathEngine.getInstance().createUnownedElement(((XMLRecord)parentRecord).getDOM(), (XMLField)this.getForeignKeyGroupingElement());
            result = new DOMRecord(newNode);
            ((DOMRecord)result).setSession(session);
        } else {
            result = this.descriptor.getObjectBuilder().createRecord(size, session);
        }
        for (int index = 0; index < size; ++index) {
            DatabaseField fkField = this.sourceForeignKeyFields.get(index);
            if (object == null) {
                result.add(fkField, null);
                continue;
            }
            DatabaseField pkField = this.sourceForeignKeysToTargetKeys.get(fkField);
            Object value = this.referenceDescriptor.getObjectBuilder().extractValueFromObjectForField(object, pkField, session);
            result.add(fkField, value);
        }
        return result;
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
            } else if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder<Object>(null));
            }
        }
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat()) {
            ((XMLRecord)row).setSession(executionSession);
        }
        ReadQuery targetQuery = this.getSelectionQuery();
        if (!this.isForeignKeyRelationship) {
            if (targetQuery.isObjectLevelReadQuery() && (sourceQuery.shouldCascadeAllParts() || sourceQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || sourceQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(sourceQuery.shouldRefreshIdentityMapResult());
                targetQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
                targetQuery.setQueryId(sourceQuery.getQueryId());
                if (targetQuery.shouldMaintainCache()) {
                    targetQuery.setShouldMaintainCache(sourceQuery.shouldMaintainCache());
                }
            }
            return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, sourceQuery.getSession());
        }
        if (this.getIndirectionPolicy().usesIndirection()) {
            EISOneToManyQueryBasedValueHolder valueholder = new EISOneToManyQueryBasedValueHolder(this, targetQuery, row, sourceQuery.getSession());
            return this.getIndirectionPolicy().buildIndirectObject(valueholder);
        }
        Vector subRows = this.getForeignKeyRows(row, executionSession);
        if (subRows == null) {
            return null;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object results = cp.containerInstance(subRows.size());
        for (int i = 0; i < subRows.size(); ++i) {
            Iterator<Object> iter;
            XMLRecord subRow = (XMLRecord)subRows.get(i);
            subRow.setSession(executionSession);
            Object object = this.getIndirectionPolicy().valueFromQuery(targetQuery, subRow, sourceQuery.getSession());
            if (object instanceof Collection) {
                iter = ((Collection)object).iterator();
                while (iter.hasNext()) {
                    cp.addInto(iter.next(), results, executionSession);
                }
                continue;
            }
            if (object instanceof Map) {
                iter = ((Map)object).values().iterator();
                while (iter.hasNext()) {
                    cp.addInto(iter.next(), results, executionSession);
                }
                continue;
            }
            cp.addInto(object, results, executionSession);
        }
        if (cp.sizeFor(results) == 0) {
            return null;
        }
        return results;
    }

    public Vector getForeignKeyRows(AbstractRecord row, AbstractSession session) {
        Vector subRows = new Vector();
        if (this.getForeignKeyGroupingElement() == null) {
            Object values;
            if (!this.getSourceForeignKeyFields().isEmpty() && (values = row.getValues(this.getSourceForeignKeyFields().get(0))) != null) {
                if (values instanceof Vector) {
                    Vector vals = (Vector)values;
                    int valuesSize = vals.size();
                    for (int j = 0; j < valuesSize; ++j) {
                        AbstractRecord newRecord = this.descriptor.getObjectBuilder().createRecord(session);
                        newRecord.put(this.getSourceForeignKeyFields().get(0), vals.get(j));
                        subRows.add(newRecord);
                    }
                } else {
                    AbstractRecord newRecord = this.descriptor.getObjectBuilder().createRecord(session);
                    newRecord.put(this.getSourceForeignKeyFields().get(0), values);
                    subRows.add(newRecord);
                }
            }
        } else {
            subRows = (Vector)row.getValues(this.getForeignKeyGroupingElement());
        }
        return subRows;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (!this.isForeignKeyRelationship) {
            return;
        }
        if (this.getSourceForeignKeysToTargetKeys() == null || this.getSourceForeignKeysToTargetKeys().isEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord referenceRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (referenceRow != null) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), referenceRow.getValues(this.getForeignKeyGroupingElement()));
            } else if (!this.getSourceForeignKeyFields().isEmpty()) {
                DatabaseField foreignKeyField = this.getSourceForeignKeyFields().get(0);
                row.put(foreignKeyField, referenceRow.getValues(foreignKeyField));
            }
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(object, session);
        if (this.getForeignKeyGroupingElement() != null) {
            Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(cp.sizeFor(attributeValue));
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                AbstractRecord nestedRow = this.extractKeyRowFromReferenceObject(cp.next(iter, session), session, row);
                nestedRows.add(nestedRow);
            }
            row.add(this.getForeignKeyGroupingElement(), nestedRows);
        } else {
            DatabaseField singleField = this.getSourceForeignKeyFields().get(0);
            DatabaseField pkField = this.getSourceForeignKeysToTargetKeys().get(singleField);
            ArrayList<Object> foreignKeys = new ArrayList<Object>(cp.sizeFor(attributeValue));
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                Object singleValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(cp.next(iter, session), pkField, session);
                foreignKeys.add(singleValue);
            }
            row.add(singleField, foreignKeys);
        }
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (!this.getSourceForeignKeyFields().isEmpty()) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsert(object, row, session);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdateAfterShallowInsert(Object object, AbstractRecord row, AbstractSession session, DatabaseTable table) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        if (this.getForeignKeyGroupingElement() != null ? !this.getForeignKeyGroupingElement().getTable().equals(table) : !this.getSourceForeignKeyFields().isEmpty() && !this.getSourceForeignKeyFields().get(0).getTable().equals(table)) {
            return;
        }
        this.writeFromObjectIntoRow(object, row, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (!this.getSourceForeignKeyFields().isEmpty()) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, row, session);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord row) throws DescriptorException {
        Object collection2;
        Object collection1;
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        AbstractSession session = writeQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(collection1 = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), session), collection2 = this.getRealCollectionAttributeValueFromObject(writeQuery.getBackupClone(), session), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), row, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isForeignKeyRelationship()) {
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            this.writeFromObjectIntoRow(object, row, session, writeType);
        } else {
            super.writeFromObjectIntoRowWithChangeRecord(changeRecord, row, session, writeType);
        }
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (!this.getSourceForeignKeyFields().isEmpty()) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeInsertFieldsIntoRow(row, session);
        }
    }

    @Override
    public void setSelectionSQLString(String sqlString) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    @Override
    public void setDeleteAllSQLString(String sqlString) {
        throw DescriptorException.invalidMappingOperation(this, "setDeleteAllSQLString");
    }
}

