/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class WaspLoader
extends URLClassLoader {
    private ClassLoader parent;
    private Map<String, byte[]> bytecodes;

    public WaspLoader(URL[] urls, ClassLoader parent, Map<String, byte[]> bytecodes) {
        super(urls, parent);
        this.parent = parent;
        this.bytecodes = bytecodes;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!name.startsWith("org.apache.jsp")) {
            clazz = this.parent.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(name);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] cdata = this.bytecodes.get(className);
        String path = className.replace('.', '/') + ".class";
        if (cdata == null && (cdata = this.loadClassDataFromFile(path)) == null) {
            throw new ClassNotFoundException(className);
        }
        return this.defineClass(className, cdata, 0, cdata.length);
    }

    private byte[] loadClassDataFromFile(String fileName) {
        byte[] classBytes = null;
        try {
            InputStream in = this.getResourceAsStream(fileName);
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            in.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return classBytes;
    }
}

