/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.asn1;

import com.jcraft.jsch.asn1.ASN1Exception;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class ASN1 {
    byte[] buf;
    int start;
    int length;

    public ASN1(byte[] buf) throws ASN1Exception {
        this(buf, 0, buf.length);
    }

    public ASN1(byte[] buf, int start, int length) throws ASN1Exception {
        this.buf = buf;
        this.start = start;
        this.length = length;
        if (start + length > buf.length) {
            throw new ASN1Exception();
        }
    }

    public int getType() {
        return this.buf[this.start] & 0xFF;
    }

    public boolean isSEQUENCE() {
        return this.getType() == 48;
    }

    public boolean isINTEGER() {
        return this.getType() == 2;
    }

    public boolean isOBJECT() {
        return this.getType() == 6;
    }

    public boolean isOCTETSTRING() {
        return this.getType() == 4;
    }

    public boolean isNULL() {
        return this.getType() == 5;
    }

    public boolean isBITSTRING() {
        return this.getType() == 3;
    }

    public boolean isCONTEXTPRIMITIVE(int tag) {
        if ((tag & 0xFFFFFF00) != 0 || (tag & 0x60) != 0) {
            throw new IllegalArgumentException();
        }
        return this.getType() == ((tag | 0x80) & 0xFF);
    }

    public boolean isCONTEXTCONSTRUCTED(int tag) {
        if ((tag & 0xFFFFFF00) != 0 || (tag & 0x40) != 0) {
            throw new IllegalArgumentException();
        }
        return this.getType() == ((tag | 0xA0) & 0xFF);
    }

    private int getLength(int[] indexp) {
        int length;
        int index = indexp[0];
        if (((length = this.buf[index++] & 0xFF) & 0x80) != 0) {
            int foo = length & 0x7F;
            length = 0;
            while (foo-- > 0) {
                length = (length << 8) + (this.buf[index++] & 0xFF);
            }
        }
        indexp[0] = index;
        return length;
    }

    public byte[] getContent() {
        int[] indexp = new int[]{this.start + 1};
        int length = this.getLength(indexp);
        int index = indexp[0];
        byte[] tmp = new byte[length];
        System.arraycopy(this.buf, index, tmp, 0, tmp.length);
        return tmp;
    }

    public ASN1[] getContents() throws ASN1Exception {
        int l;
        byte typ = this.buf[this.start];
        int[] indexp = new int[]{this.start + 1};
        if (typ == 5) {
            return new ASN1[0];
        }
        int index = indexp[0];
        ArrayList<ASN1> values = new ArrayList<ASN1>();
        for (int length = this.getLength(indexp); length > 0; length -= l) {
            --length;
            int tmp = ++index;
            indexp[0] = index;
            l = this.getLength(indexp);
            index = indexp[0];
            length -= index - tmp;
            values.add(new ASN1(this.buf, tmp - 1, 1 + (index - tmp) + l));
            index += l;
        }
        ASN1[] result = new ASN1[values.size()];
        values.toArray(result);
        return result;
    }

    public byte[] getRaw() {
        return Arrays.copyOfRange(this.buf, this.start, this.start + this.length);
    }

    public static int parseASN1IntegerAsInt(byte[] content) throws ArithmeticException {
        BigInteger b = new BigInteger(content);
        if (b.bitLength() <= 31) {
            return b.intValue();
        }
        throw new ArithmeticException("BigInteger out of int range");
    }
}

