/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Subgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jpa.AttributeNodeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.AttributeGroup;

public class EntityGraphImpl<X>
extends AttributeNodeImpl<X>
implements EntityGraph<X>,
Subgraph<X> {
    protected AttributeGroup attributeGroup;
    protected transient boolean isMutable = false;
    protected transient ClassDescriptor descriptor;
    protected Class<X> classType;
    protected Map<String, AttributeNodeImpl<?>> attributeNodes;

    protected EntityGraphImpl(AttributeGroup group, ClassDescriptor descriptor) {
        this.attributeGroup = group;
        this.classType = descriptor.getJavaClass();
        this.isMutable = true;
        this.descriptor = descriptor;
    }

    public EntityGraphImpl(AttributeGroup group) {
        this.attributeGroup = group;
        this.classType = group.getType();
        if (this.classType == null) {
            this.classType = CoreClassConstants.OBJECT;
        }
    }

    protected EntityGraphImpl(AttributeGroup group, ClassDescriptor descriptor, String attribute) {
        this(group, descriptor);
        this.currentAttribute = attribute;
    }

    public String getName() {
        return this.attributeGroup.getName();
    }

    public <Y> AttributeNode<Y> addAttributeNode(String attributeName) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        return this.addAttributeNodeImpl(attributeName);
    }

    public <Y> AttributeNode<Y> addAttributeNode(Attribute<? super X, Y> attribute) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        return this.addAttributeNodeImpl(attribute.getName());
    }

    public void addAttributeNodes(String ... attributeNames) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        for (String attrName : attributeNames) {
            this.addAttributeNodeImpl(attrName);
        }
    }

    @SafeVarargs
    public final void addAttributeNodes(Attribute<? super X, ?> ... attributes) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        for (Attribute<? super X, ?> attribute : attributes) {
            this.addAttributeNodeImpl(attribute.getName());
        }
    }

    public boolean hasAttributeNode(String attributeName) {
        return this.attributeNodes.containsKey(attributeName);
    }

    public boolean hasAttributeNode(Attribute<? super X, ?> attribute) {
        return this.hasAttributeNode(attribute.getName());
    }

    public <Y> AttributeNode<Y> getAttributeNode(String attributeName) {
        return this.attributeNodes.get(attributeName);
    }

    public <Y> AttributeNode<Y> getAttributeNode(Attribute<? super X, Y> attribute) {
        return this.attributeNodes.get(attribute.getName());
    }

    public void removeAttributeNode(String attributeName) {
        this.removeAttributeNodeImpl(attributeName);
    }

    public void removeAttributeNode(Attribute<? super X, ?> attribute) {
        this.removeAttributeNodeImpl(attribute.getName());
    }

    public void removeAttributeNodes(Attribute.PersistentAttributeType nodeTypes) {
        for (DatabaseMapping mapping : this.descriptor.getMappings()) {
            if (AttributeImpl.getPersistentAttributeType(mapping) != nodeTypes) continue;
            this.removeAttributeNodeImpl(mapping.getAttributeName());
        }
    }

    private <Y> AttributeNode<Y> addAttributeNodeImpl(String attributeName) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        if (this.descriptor.getMappingForAttributeName(attributeName) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_managed_type_attribute_not_present", (Object[])new Object[]{attributeName, this.getClassType()}));
        }
        AttributeNodeImpl attributeNode = new AttributeNodeImpl(attributeName);
        this.addAttributeNodeImpl(attributeNode);
        this.attributeGroup.addAttribute(attributeName, (AttributeGroup)null);
        return attributeNode;
    }

    protected void addAttributeNodeImpl(AttributeNodeImpl<?> attributeNode) {
        if (this.attributeNodes == null) {
            this.buildAttributeNodes();
        }
        this.attributeNodes.put(attributeNode.getAttributeName(), attributeNode);
    }

    private void removeAttributeNodeImpl(String attributeName) {
        this.attributeGroup.removeAttribute(attributeName);
        this.attributeNodes.remove(attributeName);
    }

    public <T> Subgraph<T> addSubgraph(Attribute<? super X, T> attribute) {
        Class type = attribute.getJavaType();
        if (attribute.isCollection()) {
            type = ((PluralAttribute)attribute).getBindableJavaType();
        }
        return this.addSubgraph(attribute.getName(), type);
    }

    public <S extends X> Subgraph<S> addTreatedSubgraph(Class<S> type) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        ClassDescriptor targetDesc = this.descriptor;
        if (targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"type_unkown_for_this_entity", (Object[])new Object[]{type.getName(), this.descriptor.getJavaClassName()}));
        }
        AttributeGroup subGroup = new AttributeGroup(this.attributeGroup.getName(), type, true);
        this.attributeGroup.getSubClassGroups().put(type, subGroup);
        subGroup.setAllSubclasses(this.attributeGroup.getSubClassGroups());
        this.attributeGroup.insertSubClass((CoreAttributeGroup)subGroup);
        return new EntityGraphImpl<X>(subGroup, targetDesc);
    }

    public <T> Subgraph<? extends T> addSubclassSubgraph(Class<? extends T> type) {
        return this.addTreatedSubgraph(type);
    }

    public <Y> Subgraph<Y> addTreatedSubgraph(Attribute<? super X, ? super Y> attribute, Class<Y> type) {
        return this.addSubgraph(attribute.getName(), type);
    }

    public <T> Subgraph<? extends T> addSubgraph(Attribute<? super X, T> attribute, Class<? extends T> type) {
        return this.addSubgraph(attribute.getName(), type);
    }

    public <T> Subgraph<T> addSubgraph(String attributeName) {
        return this.addSubgraph(attributeName, null);
    }

    public <T> Subgraph<T> addSubgraph(String attributeName, Class<T> type) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        AttributeNodeImpl<Object> node = null;
        if (this.attributeNodes != null) {
            node = this.attributeNodes.get(attributeName);
        }
        if (node == null) {
            node = new AttributeNodeImpl(attributeName);
            this.addAttributeNodeImpl(node);
        }
        AttributeGroup localGroup = null;
        DatabaseMapping mapping = this.descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_managed_type_attribute_not_present", (Object[])new Object[]{attributeName, this.descriptor.getJavaClassName()}));
        }
        localGroup = new AttributeGroup(attributeName, type, true);
        ClassDescriptor targetDesc = mapping.getReferenceDescriptor();
        if (type != null && targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"type_unkown_for_this_attribute", (Object[])new Object[]{type.getName(), attributeName}));
        }
        EntityGraphImpl<X> entityGraph = new EntityGraphImpl<X>(localGroup, targetDesc, attributeName);
        node.addSubgraph(entityGraph);
        this.attributeGroup.addAttribute(attributeName, localGroup);
        return entityGraph;
    }

    public <X1> Subgraph<X1> addElementSubgraph(String attributeName) {
        return this.addKeySubgraph(attributeName, null);
    }

    public <X1> Subgraph<X1> addElementSubgraph(String attributeName, Class<X1> type) {
        return this.addKeySubgraph(attributeName, type);
    }

    public <E> Subgraph<E> addElementSubgraph(PluralAttribute<? super X, ?, E> attribute) {
        return this.addKeySubgraph(attribute.getName(), attribute.getBindableJavaType());
    }

    public <E> Subgraph<E> addTreatedElementSubgraph(PluralAttribute<? super X, ?, ? super E> attribute, Class<E> type) {
        return this.addKeySubgraph(attribute.getName(), type);
    }

    public <K> Subgraph<K> addMapKeySubgraph(MapAttribute<? super X, K, ?> attribute) {
        return this.addKeySubgraph(attribute.getName(), attribute.getKeyJavaType());
    }

    public <K> Subgraph<K> addTreatedMapKeySubgraph(MapAttribute<? super X, ? super K, ?> attribute, Class<K> type) {
        return this.addKeySubgraph(attribute.getName(), type);
    }

    public <T> Subgraph<T> addKeySubgraph(Attribute<? super X, T> attribute) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        Class type = attribute.getJavaType();
        if (attribute.isCollection()) {
            type = ((PluralAttribute)attribute).getBindableJavaType();
        }
        return this.addKeySubgraph(attribute.getName(), type);
    }

    public <T> Subgraph<? extends T> addKeySubgraph(Attribute<? super X, T> attribute, Class<? extends T> type) {
        return this.addKeySubgraph(attribute.getName(), type);
    }

    public <T> Subgraph<T> addKeySubgraph(String attributeName) {
        return this.addKeySubgraph(attributeName, null);
    }

    public <T> Subgraph<T> addKeySubgraph(String attributeName, Class<T> type) {
        if (!this.isMutable) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"immutable_entitygraph"));
        }
        AttributeNodeImpl<Object> node = null;
        if (this.attributeNodes != null) {
            node = this.attributeNodes.get(attributeName);
        }
        if (node == null) {
            node = new AttributeNodeImpl(attributeName);
            this.addAttributeNodeImpl(node);
        }
        AttributeGroup localGroup = null;
        DatabaseMapping mapping = this.descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_managed_type_attribute_not_present", (Object[])new Object[]{this.descriptor.getJavaClassName(), attributeName}));
        }
        if (!mapping.getContainerPolicy().isMappedKeyMapPolicy() && !((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).isMapKeyAttribute()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"attribute_is_not_map_with_managed_key", (Object[])new Object[]{attributeName, this.descriptor.getJavaClassName()}));
        }
        localGroup = new AttributeGroup(attributeName, type, true);
        ClassDescriptor targetDesc = mapping.getContainerPolicy().getDescriptorForMapKey();
        if (type != null && targetDesc.hasInheritance() && (targetDesc = targetDesc.getInheritancePolicy().getDescriptor(type)) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"type_unkown_for_this_attribute", (Object[])new Object[]{type.getName(), attributeName}));
        }
        EntityGraphImpl<X> entityGraph = new EntityGraphImpl<X>(localGroup, targetDesc, attributeName);
        node.addKeySubgraph(entityGraph);
        this.attributeGroup.addAttributeKey(attributeName, (CoreAttributeGroup)localGroup);
        return entityGraph;
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        if (this.attributeNodes == null) {
            this.buildAttributeNodes();
        }
        return new ArrayList(this.attributeNodes.values());
    }

    public Class<X> getClassType() {
        return this.classType;
    }

    public AttributeGroup getAttributeGroup() {
        return this.attributeGroup;
    }

    @Override
    public String getAttributeName() {
        return this.currentAttribute;
    }

    protected void buildAttributeNodes() {
        this.attributeNodes = new HashMap();
        for (AttributeItem item : this.attributeGroup.getItems().values()) {
            Class type;
            AttributeNodeImpl node = new AttributeNodeImpl(item.getAttributeName());
            ClassDescriptor localDescriptor = null;
            if (this.descriptor != null) {
                localDescriptor = this.descriptor.getMappingForAttributeName(item.getAttributeName()).getReferenceDescriptor();
            }
            if (item.getGroups() != null && !item.getGroups().isEmpty()) {
                for (AttributeGroup subGroup : item.getGroups().values()) {
                    type = subGroup.getType();
                    if (type == null) {
                        type = CoreClassConstants.OBJECT;
                    }
                    if (localDescriptor != null) {
                        if (!type.equals(CoreClassConstants.OBJECT) && localDescriptor.hasInheritance()) {
                            localDescriptor = localDescriptor.getInheritancePolicy().getDescriptor(type);
                        }
                        node.addSubgraph(new EntityGraphImpl<X>(subGroup, localDescriptor));
                        continue;
                    }
                    node.addSubgraph(new EntityGraphImpl<X>(subGroup));
                }
            }
            if (item.getKeyGroups() != null && !item.getKeyGroups().isEmpty()) {
                for (AttributeGroup subGroup : item.getKeyGroups().values()) {
                    type = subGroup.getType();
                    if (type == null) {
                        type = CoreClassConstants.OBJECT;
                    }
                    if (localDescriptor != null) {
                        if (!type.equals(CoreClassConstants.OBJECT) && localDescriptor.hasInheritance()) {
                            localDescriptor = localDescriptor.getInheritancePolicy().getDescriptor(type);
                        }
                        node.addKeySubgraph(new EntityGraphImpl<X>(subGroup, localDescriptor));
                        continue;
                    }
                    node.addKeySubgraph(new EntityGraphImpl<X>(subGroup));
                }
            }
            this.attributeNodes.put(item.getAttributeName(), node);
        }
    }
}

