/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.ParentExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;

public final class RangeVariableDeclaration
extends AbstractExpression
implements ParentExpression {
    private String asIdentifier;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterRootObject;
    private AbstractExpression identificationVariable;
    private AbstractExpression rootObject;
    private boolean virtualIdentificationVariable;

    public RangeVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    public RangeVariableDeclaration(String entityName, String variableName) {
        super(null);
        this.rootObject = new AbstractSchemaName(this, entityName);
        this.identificationVariable = new IdentificationVariable(this, variableName);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRootObject().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRootObject());
        children.add(this.getIdentificationVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.rootObject != null) {
            children.add(this.rootObject);
        }
        if (this.hasSpaceAfterRootObject) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.asIdentifier != null) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.rootObject != null && this.rootObject.isAncestor(expression)) {
            return this.getQueryBNF("range_declaration");
        }
        if (this.identificationVariable != null && this.identificationVariable.isAncestor(expression)) {
            return this.getQueryBNF("identification_variable");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public List<IdentificationVariable> getIdentificationVariablesWithoutAlias() {
        return null;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("range_variable_declaration");
    }

    public Expression getRootObject() {
        if (this.rootObject == null) {
            this.rootObject = this.buildNullExpression();
        }
        return this.rootObject;
    }

    public boolean hasAs() {
        return this.asIdentifier != null;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasRootObject() {
        return this.rootObject != null && !this.rootObject.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterRootObject() {
        return this.hasSpaceAfterRootObject;
    }

    public boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    public boolean isGenerateImplicitThisAlias() {
        return false;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("AS") || word.equalsIgnoreCase("SET") || word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.rootObject = this.parse(wordParser, "range_declaration", tolerant);
        boolean bl = this.hasSpaceAfterRootObject = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("AS")) {
            this.asIdentifier = wordParser.moveForward("AS");
            boolean bl2 = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.identificationVariable = this.parse(wordParser, "identification_variable", tolerant);
            if (this.identificationVariable == null && this.getRoot().isJakartaData()) {
                this.addMissingAlias("this");
            }
        } else if (!wordParser.startsWithIdentifier("SET")) {
            this.identificationVariable = new IdentificationVariable(this, wordParser.word());
            this.identificationVariable.parse(wordParser, tolerant);
        }
    }

    @Override
    public void setGenerateImplicitThisAlias(boolean generateImplicitThisAlias) {
    }

    public void setVirtualIdentificationVariable(String variableName) {
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
    }

    public void setVirtualIdentificationVariable(String variableName, String path) {
        CollectionValuedPathExpression expression = new CollectionValuedPathExpression((AbstractExpression)this, path);
        expression.setVirtualIdentificationVariable(variableName);
        this.rootObject = expression;
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return false;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.rootObject != null) {
            this.rootObject.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterRootObject) {
            writer.append(' ');
        }
        if (this.asIdentifier != null) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
            this.identificationVariable.toParsedText(writer, actual);
        }
    }

    private void addMissingAlias(String aliasName) {
        if (this.isMissingAliasInSelectFromClause() || this.isMissingAliasInUpdateClause() || this.isMissingAliasInDeleteFromClause()) {
            this.setVirtualIdentificationVariable(aliasName);
            this.getParentExpression().setGenerateImplicitThisAlias(true);
        }
    }

    private boolean isMissingAliasInSelectFromClause() {
        IdentificationVariableDeclaration identificationVariableDeclaration;
        AbstractExpression abstractExpression = this.getParent();
        return abstractExpression instanceof IdentificationVariableDeclaration && (identificationVariableDeclaration = (IdentificationVariableDeclaration)abstractExpression).getParent() instanceof FromClause && this.getIdentificationVariable() instanceof NullExpression;
    }

    private boolean isMissingAliasInUpdateClause() {
        return this.getParent() instanceof UpdateClause && this.getIdentificationVariable() instanceof NullExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMissingAliasInDeleteFromClause() {
        AbstractExpression abstractExpression = this.getParent();
        if (!(abstractExpression instanceof DeleteClause)) return false;
        DeleteClause deleteClause = (DeleteClause)abstractExpression;
        if (!(this.getIdentificationVariable() instanceof NullExpression)) return false;
        return true;
    }
}

