/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.common;

import org.glassfish.shoal.gms.api.core.FailureRecoverySignal;
import org.glassfish.shoal.gms.api.core.GMSException;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.common.FailureNotificationSignalImpl;
import org.glassfish.shoal.gms.common.GMSContextFactory;

public class FailureRecoverySignalImpl
extends FailureNotificationSignalImpl
implements FailureRecoverySignal {
    private String componentName;

    public FailureRecoverySignalImpl(String componentName, String failedMember, String groupName, long startTime) {
        this.failedMember = failedMember;
        this.componentName = componentName;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    FailureRecoverySignalImpl(FailureRecoverySignal signal) {
        this.failedMember = signal.getMemberToken();
        this.componentName = signal.getComponentName();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        try {
            this.ctx.getGroupHandle().removeRecoveryAppointments(this.failedMember, this.componentName);
            this.failedMember = null;
        }
        catch (GMSException e) {
            throw new SignalReleaseException((Exception)((Object)e));
        }
    }

    public String getComponentName() {
        return this.componentName;
    }
}

