/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.renderkit.html.ListRendererBase;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public class DropDownRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof DropDown)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), DropDown.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        DropDown dropDown = (DropDown)component;
        if (dropDown.isForgetValue()) {
            dropDown.setValue(null);
        }
        String[] styles = dropDown.isSubmitForm() ? this.getJumpDropDownStyles(dropDown, context) : this.getDropDownStyles(dropDown, context);
        DropDownRenderer.renderListComponent(dropDown, context, styles);
        ResponseWriter writer = context.getResponseWriter();
        if (dropDown.isSubmitForm()) {
            String id = dropDown.getClientId(context).concat("_submitter");
            RenderingUtilities.renderHiddenField((UIComponent)dropDown, writer, id, "false");
        }
    }

    private String[] getDropDownStyles(DropDown component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[10];
        styles[0] = JavaScriptUtilities.renderCalls(component.getOnChange(), JavaScriptUtilities.renderCall("changed", "dropDown", component.getClientId(context)));
        styles[1] = theme.getStyleClass("MENU_STANDARD");
        styles[2] = theme.getStyleClass("MENU_STANDARD_DISABLED");
        styles[3] = theme.getStyleClass("MENU_STANDARD_OPTION");
        styles[4] = theme.getStyleClass("MENU_STANDARD_OPTION_DISABLED");
        styles[5] = theme.getStyleClass("MENU_STANDARD_OPTION_SELECTED");
        styles[6] = theme.getStyleClass("MENU_STANDARD_OPTION_GROUP");
        styles[7] = theme.getStyleClass("MENU_STANDARD_OPTION_SEPARATOR");
        styles[8] = theme.getStyleClass("HIDDEN");
        return styles;
    }

    private String[] getJumpDropDownStyles(DropDown component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[10];
        styles[0] = JavaScriptUtilities.renderCalls(component.getOnChange(), JavaScriptUtilities.renderCall("dropdown_changed", component.getClientId(context)));
        styles[1] = theme.getStyleClass("MENU_JUMP");
        styles[2] = "";
        styles[3] = theme.getStyleClass("MENU_JUMP_OPTION");
        styles[4] = theme.getStyleClass("MENU_JUMP_OPTION_DISABLED");
        styles[5] = theme.getStyleClass("MENU_JUMP_OPTION_SELECTED");
        styles[6] = theme.getStyleClass("MENU_JUMP_OPTION_GROUP");
        styles[7] = theme.getStyleClass("MENU_JUMP_OPTION_SEPARATOR");
        styles[8] = theme.getStyleClass("HIDDEN");
        return styles;
    }

    private static void log(String msg) {
        LogUtil.finest(ListRendererBase.class.getName() + "::" + msg);
    }
}

