/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager2;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager2.Employee;
import ee.jakarta.tck.persistence.core.entityManager2.Order;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TransactionRequiredException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client2
extends PMClientBase {
    Employee[] empRef = new Employee[5];
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
    String dataBaseName = null;
    static final String ORACLE = "oracle";

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        super.cleanup();
    }

    public void lockTransactionRequiredExceptionTest() throws Exception {
        Order o;
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        this.logMsg("Testing TransactionRequiredException for lock(Object, LockModeType)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException caught which can also be thrown from lock call.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TransactionRequiredException for lock(Object, LockModeType, Map)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE, myMap);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException caught which can also be thrown from lock call.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTransactionRequiredExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing refresh(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing refresh(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("refreshTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTransactionRequiredException2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException caught which can also be thrown from lock call.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing lock(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException caught which can also be thrown from lock call.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockTransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                this.logTrace("Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

