/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.DID2Employee;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.junit.jupiter.api.Disabled;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    this.logTrace("Received expected: " + name);
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.String, actual:" + name);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained A Entity");
                try {
                    iType.getId(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.Integer, actual:" + name);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained A Entity");
                try {
                    iType.getVersion(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null EntityType");
                this.logTrace("entityType Name = A");
                SingularAttribute idAttrib = iType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    this.logTrace("Received expected name:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.String, actual:" + name);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained A IdentifiableType");
                try {
                    iType.getDeclaredId(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                this.logTrace("entityType Name = " + iType.getName());
                SingularAttribute idAttrib = iType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    this.logTrace("Received:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected: value, actual:" + name);
                }
            } else {
                this.logErr("getEntities(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                this.logTrace("entityType Name = " + iType.getName());
                try {
                    iType.getDeclaredVersion(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntities(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getSupertype() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("entityType Name = " + iType.getName());
                IdentifiableType idType = iType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    this.logTrace("getSuperType() returned:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected: " + expected + ", actual:" + name);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSupertype failed");
        }
    }

    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("entityType Name = " + iType.getName());
                boolean hasSingleIdAttribute = iType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    this.logTrace("hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                } else {
                    this.logErr("Expected: false, actual:" + hasSingleIdAttribute);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("entityType Name = " + iType.getName());
                boolean hasVersionAttribute = iType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    this.logTrace("hasSingleIdAttribute() returned" + hasVersionAttribute);
                } else {
                    this.logErr("Expected: false, actual:" + hasVersionAttribute);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(DID2Employee.class);
            if (iType != null) {
                Set idClassAttribSet = iType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    for (SingularAttribute attrib : idClassAttribSet) {
                        this.logTrace("attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained A Entity");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getIdClassAttributes();
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Type idType = iType.getIdType();
                if (idType != null) {
                    this.logTrace("idType Name = " + idType.getJavaType());
                    String name = idType.getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        this.logTrace("Received expected: " + name);
                        pass = true;
                    } else {
                        this.logErr("Expected java.lang.String, actual:" + name);
                    }
                } else {
                    this.logErr("getIdType() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdType failed");
        }
    }

    public void getAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Attribute attrib = iType.getAttribute("id");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("id")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: id, actual:" + name);
                    }
                } else {
                    this.logErr("getAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                try {
                    iType.getAttribute("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    public void getAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("id");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("name");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    public void getCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClass failed");
        }
    }

    public void getCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress");
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionString failed");
        }
    }

    public void getCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Attribute attrib = iType.getDeclaredAttribute("cAddress");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("cAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    public void getDeclaredAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredAttribute("cAddress_inherited");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getDeclaredAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    public void getDeclaredCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClass failed");
        }
    }

    public void getDeclaredCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    this.logTrace("attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: cAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionString failed");
        }
    }

    public void getDeclaredCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress", Address.class);
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClass failed");
        }
    }

    public void getDeclaredListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress");
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListString failed");
        }
    }

    public void getDeclaredListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClass failed");
        }
    }

    public void getDeclaredMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited", Address.class, String.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress");
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapString failed");
        }
    }

    public void getDeclaredMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress", Address.class);
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClass failed");
        }
    }

    public void getDeclaredSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress");
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetString failed");
        }
    }

    public void getDeclaredSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value", Integer.class);
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: value, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClass failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name", String.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value");
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: value, actual:" + name);
                    }
                } else {
                    this.logErr("getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeString failed");
        }
    }

    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    @Disabled
    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getDeclaredSingularAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    public void getListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress", Address.class);
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClass failed");
        }
    }

    public void getListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getList("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentException failed");
        }
    }

    public void getListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress");
                if (lAttrib != null) {
                    this.logTrace("attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: lAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getList(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListString failed");
        }
    }

    public void getListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentException failed");
        }
    }

    public void getMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClass failed");
        }
    }

    public void getMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist", Address.class, String.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress");
                if (mAttrib != null) {
                    this.logTrace("attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: mAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getMap(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapString failed");
        }
    }

    public void getMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentException failed");
        }
    }

    public void getPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getPluralAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getPluralAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getPluralAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getPluralAttributes() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    public void getSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress", Address.class);
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClass failed");
        }
    }

    public void getSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentException failed");
        }
    }

    public void getSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress");
                if (sAttrib != null) {
                    this.logTrace("attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: sAddress, actual:" + name);
                    }
                } else {
                    this.logErr("getSet(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetString failed");
        }
    }

    public void getSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name", String.class);
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: name, actual:" + name);
                    }
                } else {
                    this.logErr("getSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClass failed");
        }
    }

    public void getSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist", Address.class);
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name");
                if (singAttrib != null) {
                    this.logTrace("attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        this.logTrace("Received expected result:" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: name, actual:" + name);
                    }
                } else {
                    this.logErr("getSingularAttribute(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeString failed");
        }
    }

    public void getSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist");
                    this.logErr("Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    this.logErr("Received unexpected exception:", ex);
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                this.logTrace("Obtained Non-null Entity A");
                Set set = iType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String attribName : expected) {
                                this.logTrace("attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received unexpected attributes");
                            this.logErr("Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                this.logErr("attrib:" + attribName);
                            }
                            this.logErr("Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getSingularAttributes() returned 0 results");
                    }
                } else {
                    this.logErr("getSingularAttributes(...) returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

