/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.version;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.annotations.version.Client;
import ee.jakarta.tck.persistence.core.annotations.version.ShortClass_Field;
import ee.jakarta.tck.persistence.core.annotations.version.ShortClass_Property;
import ee.jakarta.tck.persistence.core.annotations.version.Short_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Short_Property;
import java.util.Properties;
import java.util.logging.Logger;

public class Client2
extends Client {
    static final Logger log = Logger.getLogger(Client2.class.getName());

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setupShortData");
        log.info("setupShortData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createShortTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    public void shortFieldTest() throws Exception {
        boolean pass = false;
        try {
            Short_Field a = (Short_Field)this.getEntityManager().find(Short_Field.class, (Object)"1");
            if (a != null) {
                this.logTrace("version:" + a.getVersion());
                short version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Short_Field a1 = (Short_Field)this.getEntityManager().find(Short_Field.class, (Object)"1");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        this.logTrace("version:" + a1.getVersion());
                        pass = true;
                    } else {
                        this.logErr("Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    this.logErr("Second find returned null result");
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("shortFieldTest failed");
        }
    }

    public void shortPropertyTest() throws Exception {
        boolean pass = false;
        try {
            Short_Property a = (Short_Property)this.getEntityManager().find(Short_Property.class, (Object)"2");
            if (a != null) {
                this.logTrace("version:" + a.getBasicShort());
                short version = a.getBasicShort();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Short_Property a1 = (Short_Property)this.getEntityManager().find(Short_Property.class, (Object)"2");
                if (a1 != null) {
                    if (a1.getBasicShort() > version) {
                        this.logTrace("version:" + a1.getBasicShort());
                        pass = true;
                    } else {
                        this.logErr("Did not get a greater version after a modification:" + a1.getBasicShort());
                    }
                } else {
                    this.logErr("Second find returned null result");
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("shortPropertyTest failed");
        }
    }

    public void shortClassFieldTest() throws Exception {
        boolean pass = false;
        try {
            ShortClass_Field a = (ShortClass_Field)this.getEntityManager().find(ShortClass_Field.class, (Object)"3");
            log.info("shortFieldTest, a=" + String.valueOf(a));
            if (a != null) {
                this.logTrace("version:" + a.getVersion());
                Short version = a.getVersion();
                log.info("shortFieldTest, a.version=" + version);
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                ShortClass_Field a1 = (ShortClass_Field)this.getEntityManager().find(ShortClass_Field.class, (Object)"3");
                log.info("shortFieldTest, a1=" + String.valueOf(a1));
                if (a1 != null) {
                    if (a1.getVersion() == null) {
                        this.logErr("version is null for updated entity");
                    } else if (version == null || a1.getVersion() > version) {
                        this.logTrace("version:" + a1.getVersion());
                        pass = true;
                    } else {
                        this.logErr("Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    this.logErr("Second find returned null result");
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("shortClassFieldTest failed");
        }
    }

    public void shortClassPropertyTest() throws Exception {
        boolean pass = false;
        try {
            ShortClass_Property a = (ShortClass_Property)this.getEntityManager().find(ShortClass_Property.class, (Object)"4");
            if (a != null) {
                this.logTrace("version:" + a.getBasicShort());
                Short version = a.getBasicShort();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                ShortClass_Property a1 = (ShortClass_Property)this.getEntityManager().find(ShortClass_Property.class, (Object)"4");
                if (a1 != null) {
                    if (a1.getBasicShort() == null) {
                        this.logErr("version is null for updated entity");
                    } else if (version == null || a1.getBasicShort() > version) {
                        this.logTrace("version:" + a1.getBasicShort());
                        pass = true;
                    } else {
                        this.logErr("Did not get a greater version after a modification:" + a1.getBasicShort());
                    }
                } else {
                    this.logErr("Second find returned null result");
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("shortClassPropertyTest failed");
        }
    }

    public void createShortTestData() {
        this.logTrace("createShortTestData");
        log.info("createShortTestData");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)new Short_Field("1"));
            this.getEntityManager().persist((Object)new Short_Property("2"));
            this.getEntityManager().persist((Object)new ShortClass_Field("3"));
            this.getEntityManager().persist((Object)new ShortClass_Property("4"));
            this.getEntityTransaction().commit();
            log.info("createShortTestData, committed objects");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createShortTestData:", e);
            log.severe("Unexpected Exception in createShortTestDat" + e.getMessage());
        }
        finally {
            log.info("createShortTestData, finally tx.isActive()=" + this.getEntityTransaction().isActive());
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }
}

