/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.basic;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.basic.Order;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void updateOrderTest() throws Exception {
        int i;
        boolean pass = true;
        int count = 6;
        Order order = null;
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = new Order(i, 100 * i);
            this.getEntityManager().persist((Object)order);
            this.logTrace("persisted order " + String.valueOf(order));
        }
        this.getEntityTransaction().commit();
        this.logTrace("find and removing the previously persisted orders");
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = (Order)this.getEntityManager().find(Order.class, (Object)i);
            if (order != null) {
                this.getEntityManager().remove((Object)order);
                this.logTrace("Found and removed order " + String.valueOf(order));
                continue;
            }
            this.logErr("persisted order[" + i + "] DOES NOT EXIST");
            pass = false;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            this.logTrace("clearing the persistence context");
            this.clearCache();
            this.logTrace("verify the previously removed orders were removed");
            for (i = 1; i < 6; ++i) {
                order = (Order)this.getEntityManager().find(Order.class, (Object)i);
                if (order == null) {
                    this.logTrace("persisted order[" + i + "] was removed successfully");
                    continue;
                }
                this.logErr("order[" + i + "] was NOT removed");
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("updateOrderTest failed");
        }
    }

    public void newEntityTest() throws Exception {
        boolean pass = false;
        this.logTrace("Instantiate an order ");
        Order order = new Order(1, 101);
        this.logTrace("Try to find it");
        Order order2 = (Order)this.getEntityManager().find(Order.class, (Object)1);
        if (order2 == null) {
            this.logTrace("Did not find order as expected");
            pass = true;
        } else {
            this.logErr("Found order when it should not exist" + order2.toString());
        }
        if (!pass) {
            throw new Exception("newEntityTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

