/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.ShelfLife;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct_;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Client5
extends Util {
    public static void main(String[] args) {
        Client5 theTests = new Client5();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupProductData")
    public void primaryKeyJoinColumnTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            cquery.select((Selection)product);
            cquery.where((Expression)cbuilder.equal((Expression)product.get("wareHouse"), (Object)"WH5"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 1 && ((Product)result.get(0)).getWareHouse().equals("WH5")) {
                this.logTrace("Expected results received:" + ((Product)result.get(0)).getWareHouse());
                pass = true;
            } else {
                this.logErr("test returned: " + ((Product)result.get(0)).getWareHouse() + ", expected: WH5");
                for (Product p : result) {
                    this.logErr("**id=" + p.getId() + ", model=" + p.getWareHouse());
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void asc() throws Exception {
        int expectedModelNumber = 40;
        int expectedResultSize = 10;
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(HardwareProduct.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            cquery.select((Selection)hardProd);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber")))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 10 && ((HardwareProduct)result.get(0)).getModelNumber() == 40) {
                this.logTrace("Expected results received.");
                pass = true;
            } else {
                this.logErr("test returned: " + ((HardwareProduct)result.get(0)).getModelNumber() + ", expected: 40");
                for (HardwareProduct o : result) {
                    this.logErr("**id=" + o.getId() + ", model=" + o.getModelNumber());
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("asc Test  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void desc() throws Exception {
        int expectedModelNumber = 104;
        int expectedResultSize = 10;
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(HardwareProduct.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            cquery.select((Selection)hardProd);
            cquery.orderBy(new Order[]{cbuilder.desc((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber")))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 10 && ((HardwareProduct)result.get(7)).getModelNumber() == 104) {
                this.logTrace("Expected results received.");
                pass = true;
            } else {
                this.logErr("test returned: " + ((HardwareProduct)result.get(7)).getModelNumber() + "expected: 104");
                for (HardwareProduct o : result) {
                    this.logErr("**id=" + o.getId() + ", model=" + o.getModelNumber());
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("desc Test  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Number.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("price", Double.class));
            cquery.select((Selection)cbuilder.sum((Expression)e));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            double d1 = 33387.14;
            double d2 = 33387.15;
            Number d3 = (Number)tq.getSingleResult();
            if (d3 instanceof Double) {
                this.logTrace("Received expected type of Double");
                pass1 = true;
            } else {
                this.logErr("Expected type Double, actual:" + String.valueOf(d3));
            }
            double d4 = d3.doubleValue();
            if (d4 >= d1 && d4 < d2) {
                this.logTrace("sum returned expected results: " + d1);
                pass2 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("sumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpNumTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Expression)e, (Number)100));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + 100;
            if (actual.equals(expected)) {
                this.logTrace("sum returned expected results: " + actual);
                pass = true;
            } else {
                this.logErr("Expected value:" + expected + ", actual value:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sumExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumNumExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Number)100, (Expression)e));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + 100;
            if (actual.equals(expected)) {
                this.logTrace("sum test returned expected results: " + actual);
                pass = true;
            } else {
                this.logErr("Expected value:" + expected + ", actual value:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sumNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Expression)e, (Expression)e));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + this.productRef[0].getQuantity();
            if (actual.equals(expected)) {
                this.logTrace("sum test returned expected results: " + actual);
                pass = true;
            } else {
                this.logErr("Expected value:" + expected + ", actual value:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sumExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void exists() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"19"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cquery.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            if (hardProd.getModel().getName().equals(Product.class.getSimpleName())) {
                this.logTrace("Received expected subquery root");
            } else {
                this.logErr("Expected subquery root:" + Product.class.getSimpleName() + ", actual:" + hardProd.getModel().getName());
            }
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"19")).select((Expression)hardProd);
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)product);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("exists test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void subqueryFromEntityTypeTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"19"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cquery.subquery(Product.class);
            Root hardProd = sq.from(Product_);
            if (hardProd.getModel().getName().equals(Product_.getName())) {
                this.logTrace("Received expected subquery root");
            } else {
                this.logErr("Expected subquery root:" + Product_.getName() + ", actual:" + hardProd.getModel().getName());
            }
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"19")).select((Expression)hardProd);
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)product);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryFromEntityTypeTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void all() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(10050);
        expected.add(2578);
        expected.add(3000);
        expected.add(10000);
        expected.add(2368);
        Collections.sort(expected);
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            Subquery sq = cquery.subquery(Integer.class);
            Root subHardProd = sq.from(HardwareProduct.class);
            sq.select((Expression)subHardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)));
            sq.where((Expression)cbuilder.lt((Expression)subHardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)), (Number)1050));
            cquery.select((Selection)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)));
            cquery.where((Expression)cbuilder.gt((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)), cbuilder.all(sq)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected results");
                for (Integer i : expected) {
                    this.logErr("expected:" + i);
                }
                for (Integer i : actual) {
                    this.logErr("actual:" + i);
                }
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("all test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumAsDoubleTest() throws Exception {
        boolean pass = false;
        double expected = 217.5;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Double.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where(new Predicate[]{cb.gt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50), cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)100)});
            cquery.select((Selection)cb.sumAsDouble(cb.toFloat(cb.prod((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(0.5f)))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double actual = (Double)tq.getSingleResult();
            this.logTrace("actual" + actual);
            if (expected == actual) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("expected: " + expected + ", actual: " + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sumAsDoubleTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumAsLongTest() throws Exception {
        boolean pass = false;
        long expected = 435L;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Long.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where(new Predicate[]{cb.gt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50), cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)100)});
            cquery.select((Selection)cb.sumAsLong((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tq.getSingleResult();
            this.logTrace("actual" + actual);
            if (expected == actual) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("expected: " + expected + ", actual: " + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sumAsLongTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanExpNumTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThan((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Comparable)Integer.valueOf(50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("lessThanExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThan((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("lessThanExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanOrEqualToExpNumTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThanOrEqualTo((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Comparable)Integer.valueOf(50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("lessThanOrEqualToExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanOrEqualToExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThanOrEqualTo((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("lessThanOrEqualToExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void between() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"31", "32", "33", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        Date date1 = this.getSQLDate("2000-02-14");
        Date date6 = this.getSQLDate("2005-02-18");
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            EmbeddableType ShelfLife_ = mm.embeddable(ShelfLife.class);
            cquery.select((Selection)product);
            cquery.where((Expression)cbuilder.between((Expression)product.get(Product_.getSingularAttribute("shelfLife", ShelfLife.class)).get(ShelfLife_.getSingularAttribute("soldDate", Date.class)), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "date6")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("date1", (Object)date1);
            tq.setParameter("date6", (Object)date6);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("between test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void ltExpNumTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("ltExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void ltExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("ltExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void leExpNumTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cbuilder.le((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("leExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void leExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cbuilder.le((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cbuilder.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("leExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void neg() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.neg((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = -5;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedResult);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("neg test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodExpNumTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(10.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number result = (Number)tq.getSingleResult();
            Float expectedResult = Float.valueOf(50.0f);
            if (result instanceof Float) {
                this.logTrace("Received expected type of Float");
                pass1 = true;
            } else {
                this.logErr("Expected type Double, actual:" + String.valueOf(result));
            }
            Float f = Float.valueOf(result.floatValue());
            if (f.floatValue() == (float)expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results:" + f);
                pass2 = true;
            } else {
                this.logErr("test returned:" + result.intValue() + "expected: " + expectedResult.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("prodExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodNumExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Number)10, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 50;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results:" + result);
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedResult);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("prodNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodExpExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 25;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results:" + result);
                pass = true;
            } else {
                this.logErr("expected: " + expectedResult + ", actual result:" + result);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("prodExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffExpNumberTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)2));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 3;
            if (result.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results" + result);
                pass = true;
            } else {
                this.logErr("Expected: " + expected + ", actual:" + result);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("diffExpNumberTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffNumberExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Number)8, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 3;
            if (result.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results" + result);
                pass = true;
            } else {
                this.logErr("Expected: " + expected + ", actual:" + result);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("diffNumberExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffExpExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 0;
            if (result.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results" + result);
                pass = true;
            } else {
                this.logErr("Expected: " + expected + ", actual:" + result);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("diffExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotExpNumTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)2));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 2;
            if (actual.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("expected: " + expected + ", actual:" + actual.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("quotExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotNumExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Number)10, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 2;
            if (actual.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("expected: " + expected + ", actual:" + actual.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("quotNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotExpExpTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 1;
            if (actual.intValue() == expected.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("expected: " + expected + ", actual:" + actual.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("quotExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modExpIntTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), Integer.valueOf(100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("modExpIntTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), cbuilder.literal((Object)100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("modExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modIntExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(Integer.valueOf(550), cbuilder.literal((Object)100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("modIntExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sqrt() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.sqrt((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double result = (Double)tq.getSingleResult();
            Double expectedResult = 2.1;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result.intValue() + "expected: " + expectedResult.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("sqrt test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toLong() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toLong(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)5L)));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long result = (Long)tq.getSingleResult();
            Long expectedResult = 25L;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result.intValue() + "expected: " + expectedResult.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toLong test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toInteger() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toInteger((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("partNumber", Long.class)), (Object)373767373));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 5;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedResult);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toInteger test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toFloat() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Float.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toFloat(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(0.5f))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Float result = (Float)tq.getSingleResult();
            Float expectedResult = Float.valueOf(2.5f);
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result.intValue() + "expected: " + expectedResult.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toFloat test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toDouble() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toDouble(cbuilder.sqrt((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double result = (Double)tq.getSingleResult();
            Double expectedResult = 2.1;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result.intValue() + "expected: " + expectedResult.intValue());
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toDouble test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toBigDecimal() throws Exception {
        BigDecimal expectedResult = new BigDecimal("50.5");
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(BigDecimal.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toBigDecimal(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)new BigDecimal("10.1"))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            BigDecimal result = (BigDecimal)tq.getSingleResult();
            if (result.compareTo(expectedResult) == 0) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + String.valueOf(result) + "expected: " + String.valueOf(expectedResult));
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toBigDecimal test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toBigInteger() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(BigInteger.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toBigInteger(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)new BigInteger("10000000000"))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            BigInteger result = (BigInteger)tq.getSingleResult();
            BigInteger expectedResult = new BigInteger("50000000000");
            if (result.compareTo(expectedResult) == 0) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + String.valueOf(result) + "expected: " + String.valueOf(expectedResult));
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toBigInteger test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toStringTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toString(cbuilder.literal((Object)Character.valueOf('a'))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            String expectedResult = "a";
            if (result.equals(expectedResult)) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedResult);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("toStringTest test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void literal() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)product.get(Product_.getSingularAttribute("quantity", Integer.class)));
            cquery.where((Expression)cbuilder.equal(cbuilder.literal((Object)5), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 5;
            if (result.intValue() == expectedResult.intValue()) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("test returned:" + result + "expected: " + expectedResult);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("literal test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentDate() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Date.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentDate());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Date result = (Date)tq.getSingleResult();
            Date d = Date.valueOf(result.toString());
            if (d.toString().equals(result.toString())) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("Did not get the expected Date object");
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("currentDate test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentTime() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Time.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentTime());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Time result = (Time)tq.getSingleResult();
            Time ts = new Time(result.getTime());
            if (result.equals(ts)) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("Did not get the expected Time object");
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("currentTimes test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentTimestamp() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Timestamp.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentTimestamp());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Timestamp result = (Timestamp)tq.getSingleResult();
            Timestamp ts = Timestamp.valueOf(result.toString());
            if (ts.equals(result)) {
                this.logTrace("Successfully returned expected results");
                pass = true;
            } else {
                this.logErr("Did not get the expected Timestamp object");
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("currentTimestamp test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void treatPathClassTest() throws Exception {
        boolean pass = false;
        this.logTrace("*****************************");
        this.logTrace("SoftwareProducts:");
        this.logTrace("--------------------");
        for (SoftwareProduct p : this.softwareRef) {
            this.logTrace("ID:" + p.getId() + ":" + String.valueOf(this.getEntityManager().find(Product.class, (Object)p.getId())));
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)product.get(Product_.getSingularAttribute("id", String.class)));
            cquery.where((Expression)cbuilder.like((Expression)cbuilder.treat(product, SoftwareProduct.class).get(SoftwareProduct_.name), "Java%"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            ArrayList<String> expected = new ArrayList<String>();
            expected.add("34");
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results.  Expected: " + expected.size() + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("treatPathClassTest failed");
        }
    }
}

